<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<div class="svq-interest-tags">
    <div class="tags-category section-reveal">
		<?php

		$categories = fup_get_following_categories( false, false, true );

		fup_load_template( 'sections/listing/category', [
			'categories'          => $categories['categories'],
			'followingCategories' => fup_get_following_categories_ids()
		] );

		?>
    </div>

	<?php

	$load_more       = false;
	$category_limits = fup_get_api_limit( 'categories' );

	if ( count( $categories['categories'] ) >= $category_limits['initial'] ) {
		$load_more = true;
	}

	?>

	<?php if ( $load_more ) : ?>
        <div class="svq-load-more">
            <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                    data-hash="<?php echo esc_attr( $categories['hash'] ) ?>"
                    data-more="categories">
                <span class="btn--loading-state">
                    <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                </span>
                <span class="btn--default-state"><?php esc_html_e( '+ Load more', 'front-user-profile' ) ?></span>
            </button>
        </div>
	<?php endif; ?>
</div>
