<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<div class="section-reveal">

	<?php

	$bookmarks = fup_get_bookmarked_posts();

	?>
	<?php if ( empty( $bookmarks ) ) : ?>
        <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
			<?php esc_html_e( 'You don\'t have any bookmarks.', 'front-user-profile' ) ?>
        </div>
	<?php else : ?>
        <div class="bookmarks-listings svq-article--list">
			<?php

			if ( $bookmarks && $bookmarks->have_posts() ) {
				while ( $bookmarks->have_posts() ) {
					$bookmarks->the_post();
					fup_load_template( 'sections/article/default' );
				}
			}

			wp_reset_postdata();
			?>
        </div>
	<?php endif; ?>

	<?php

	$load_more   = false;
	$post_limits = fup_get_api_limit( 'posts' );

	if ( $bookmarks && ! empty( $bookmarks ) && $bookmarks->post_count >= $post_limits['initial'] ) {
		$load_more = true;
	}

	?>

	<?php if ( ! empty( $bookmarks ) && $load_more ) : ?>
        <div class="svq-load-more">
            <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                    data-more="bookmarks">
                <span class="btn--loading-state">
                    <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                </span>
                <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
            </button>
        </div>
	<?php endif; ?>

</div>
