<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! isset( $followers ) ) {
	$followers = fup_get_follower_authors();
}

$meta_classes = [];

if ( isset( $notification ) && $notification ) {
	$meta_classes[] = 'new-follower';
}

$meta_classes = implode( ' ', $meta_classes );

?>

<?php if ( empty( $followers ) ) : ?>
    <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
		<?php esc_html_e( 'You do not have any followers.', 'front-user-profile' ) ?>
    </div>
<?php else: ?>
    <div class="followers-listing">
        <div class="people-listings followers-listing followers-listing--grid section-reveal">
			<?php
			fup_load_template( 'sections/listing/followers', [
				'followers'    => $followers,
				'meta_classes' => $meta_classes
			] );
			?>
        </div>

		<?php

		$load_more     = false;
		$author_limits = fup_get_api_limit( 'authors' );

		if ( count( $followers ) >= $author_limits['initial'] ) {
			$load_more = true;
		}

		?>

		<?php if ( $load_more ) : ?>
            <div class="svq-load-more">
                <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                        data-more="followers">
                    <span class="btn--loading-state">
                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
                        <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                    </span>
                    <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
                </button>
            </div>
		<?php endif; ?>
    </div>
<?php endif; ?>
