<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$blocked = fup_get_blocked_authors();

?>

<?php if ( empty( $blocked ) ) : ?>
    <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
		<?php esc_html_e( 'You have not blocked any authors.', 'front-user-profile' ) ?>
    </div>
<?php else: ?>
    <div class="followers-listing">
        <div class="people-listings grid-listings section-reveal">
			<?php
			fup_load_template( 'sections/listing/blocked', [
				'blocked' => $blocked
			] );
			?>
        </div>

		<?php

		$load_more     = false;
		$author_limits = fup_get_api_limit( 'authors' );

		if ( count( $blocked ) >= $author_limits['initial'] ) {
			$load_more = true;
		}

		?>

		<?php if ( $load_more ) : ?>
            <div class="svq-load-more">
                <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                        data-more="blocked">
                    <span class="btn--loading-state">
                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
                        <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                    </span>
                    <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
                </button>
            </div>
		<?php endif; ?>
    </div>
<?php endif; ?>
