<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$thumb_id    = get_post_thumbnail_id();
$thumb_post  = get_post( $thumb_id );
$image_thumb = wp_get_attachment_image_src( $thumb_id );
$image_full  = wp_get_attachment_image_src( $thumb_id, 'full' );

$image_thumb = ( $image_thumb ) ? $image_thumb[0] : '';
$image_full  = ( $image_full ) ? $image_full[0] : '';

?>

<div class="svq-article-col">
    <article class="svq-article svq-article--list format-standard will-animate" data-cssanimate="fadeIn">
        <div class="heading-title">
            <div class="heading-title-content">
                <h4 class="heading-title-text">
                    <a href="<?php the_permalink() ?>" class="heading-title-link">
						<?php the_title() ?>
                    </a>
                </h4>
            </div>
        </div>

        <div class="entry-meta entry-meta--one-line">
            <div class="entry-meta__content">
                <span class="by-line">
                    <span class="author">
                        <a href="<?php the_permalink() ?>"><?php the_author() ?></a>
                    </span>
                </span>
                <span class="posted-on">
                    <a href="<?php the_permalink() ?>" class="posted-on__updated">
                        <time class="entry-date published" datetime="<?php the_date( 'Y-m-d H:i' ); ?>">
                            <?php echo get_the_date(); ?>
                        </time>
                    </a>
                </span>
            </div>
        </div>

		<?php if ( $image_full && $image_thumb ) : ?>
            <div class="post-thumbnail">
                <figure class="svq-media-image">
                    <div class="svq-progressive">
                        <div class="aspect-ratio-placeholder-fill aspect-ratio-1-1"></div>
                        <div class="svq-progressive__placeholder-image">
                            <a href="<?php the_permalink() ?>">
                                <img class="svq-progressive__image"
                                     data-src="<?php echo esc_url( $image_full ) ?>"
                                     data-progressive-sm="<?php echo esc_url( $image_thumb ) ?>"
                                     src="<?php echo esc_url( $image_thumb ) ?>">
                            </a>
                            <span class="svq-img-loader"></span>
                            <noscript class="svq-noscript-image">v
                                <a href="<?php the_permalink() ?>">
                                    <img src="<?php echo esc_url( $image_full ) ?>"
                                         data-src="<?php echo esc_url( $image_full ) ?>">
                                </a>
                            </noscript>
                        </div>
                        <div class="solid-bg"></div>
                    </div>
                </figure>
            </div>
		<?php endif; ?>

        <div class="post-excerpt">
			<?php the_excerpt() ?>
        </div>
    </article>
    <span class="svq-article-loader"></span>
</div>
