<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$profileUser = fup_get_user();

if ( ! $profileUser ) {
	return;
}

?>

<?php if ( ! fup_is_current_user() ): ?>
    <h3 class="widget-title">
        <span>
	        <?php echo sprintf( esc_html__( "%s's articles", 'front-user-profile' ), $profileUser->data->display_name ) ?>
        </span>
    </h3>
<?php endif; ?>

<?php if ( fup_is_current_user() ): ?>
    <nav class="nav-horizontal">
        <div class="nav-scroll-mask">
            <ul class="nav nav-tabs nav-tabs--blog" role="tablist" id="fup-tabs">
                <li class="nav-item">
                    <a class="nav-link active" href="#feed" data-toggle="tab" role="tab" aria-controls="feed"
                       aria-selected="true">
						<?php esc_html_e( 'Authors feed', 'front-user-profile' ) ?>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#feed-category" data-toggle="tab" role="tab" aria-controls="feed-category"
                       aria-selected="true">
						<?php esc_html_e( 'Categories feed', 'front-user-profile' ) ?>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#my-stories" data-toggle="tab" role="tab"
                       aria-controls="my-stories" aria-selected="false">
						<?php esc_html_e( 'Stories I wrote', 'front-user-profile' ) ?>
                    </a>
                </li>
				<?php if ( fup_show( 'drafts' ) ) : ?>
                    <li class="nav-item">
                        <a class="nav-link" href="#drafts" data-toggle="tab" role="tab" aria-controls="drafts"
                           aria-selected="false">
							<?php esc_html_e( 'Drafts', 'front-user-profile' ) ?>
                        </a>
                    </li>
				<?php endif; ?>
            </ul>
        </div>
    </nav>
<?php endif; ?>

<?php if ( fup_is_current_user() ): ?>
    <div class="tab-content tab-content--blog">
        <div class="tab-pane fade show active" id="feed">
			<?php fup_load_template( 'sections/feed' ) ?>
        </div>

        <div class="tab-pane fade" id="feed-category">
			<?php fup_load_template( 'sections/feed-category' ) ?>
        </div>

        <div class="tab-pane fade" id="my-stories">
			<?php fup_load_template( 'sections/my-stories' ) ?>
        </div>

		<?php if ( fup_show( 'drafts' ) ) : ?>
            <div class="tab-pane fade" id="drafts">
				<?php fup_load_template( 'sections/drafts' ) ?>
            </div>
		<?php endif; ?>
    </div>
<?php else : ?>
    <div class="">
		<?php fup_load_template( 'sections/my-stories' ) ?>
    </div>
<?php endif; ?>
