<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$lastVisit = get_user_meta( get_current_user_id(), 'fup_last_followers_check', true );
$followers = fup_get_follower_authors();

$notification = false;

if ( $lastVisit ) {
	foreach ( $followers as $follower ) {
		if ( strtotime( $follower->since ) > strtotime( $lastVisit ) ) {
			$notification = true;
		}
	}
}

$notification_classes = [];
$notification_action  = '';

if ( $notification ) {
	$notification_classes[] = 'has-notifications';
	$notification_action    = 'data-action="fup-update-followers-notification"';
}

$notification_classes = implode( ' ', $notification_classes );

?>

<nav class="nav-horizontal">
    <div class="nav-scroll-mask">
        <ul class="nav nav-tabs nav-tabs--blog" role="tablist" id="fup-tabs">
			<?php if ( fup_can( 'follow-category' ) ) : ?>
                <li class="nav-item">
                    <a class="nav-link active" href="#interests" data-toggle="tab" role="tab" aria-controls="interests"
                       aria-selected="true">
						<?php esc_html_e( 'My interests', 'front-user-profile' ) ?>
                    </a>
                </li>
			<?php endif; ?>
			<?php if ( fup_can( 'bookmark' ) ) : ?>
                <li class="nav-item">
                    <a class="nav-link" href="#bookmarks" data-toggle="tab" role="tab" aria-controls="bookmarks"
                       aria-selected="true">
						<?php esc_html_e( 'My bookmarks', 'front-user-profile' ) ?>
                    </a>
                </li>
			<?php endif; ?>
			<?php if ( fup_can( 'follow-user' ) ) : ?>
                <li class="nav-item">
                    <a class="nav-link" href="#following" data-toggle="tab" role="tab" aria-controls="following"
                       aria-selected="true">
						<?php esc_html_e( 'I\'m following', 'front-user-profile' ) ?>
                    </a>
                </li>
                <li class="nav-item <?php echo esc_attr( $notification_classes ) ?>">
                    <a class="nav-link" href="#followers" data-toggle="tab" role="tab" aria-controls="followers"
                       aria-selected="true" <?php echo esc_attr( $notification_action ) ?>>
						<?php esc_html_e( 'My followers', 'front-user-profile' ) ?>
                    </a>
                </li>
			<?php endif; ?>
			<?php if ( fup_can( 'block-user' ) ) : ?>
                <li class="nav-item">
                    <a class="nav-link" href="#blocked" data-toggle="tab" role="tab" aria-controls="blocked"
                       aria-selected="true">
						<?php esc_html_e( 'Blocked', 'front-user-profile' ) ?>
                    </a>
                </li>
			<?php endif; ?>
        </ul>
    </div>
</nav>

<div class="tab-content tab-content--blog">
	<?php if ( fup_can( 'follow-category' ) ) : ?>
        <div class="tab-pane fade show active" id="interests">
			<?php fup_load_template( 'sections/categories-following' ); ?>
        </div>
	<?php endif; ?>
	<?php if ( fup_can( 'bookmark' ) ) : ?>
        <div class="tab-pane fade" id="bookmarks">
			<?php fup_load_template( 'sections/bookmarks' ); ?>
        </div>
	<?php endif; ?>
	<?php if ( fup_can( 'follow-user' ) ) : ?>
        <div class="tab-pane fade" id="following">
			<?php fup_load_template( 'sections/authors-following' ); ?>
        </div>
        <div class="tab-pane fade" id="followers">
			<?php fup_load_template( 'sections/authors-followers',
				[ 'followers' => $followers, 'notification' => $notification ] );
			?>
        </div>
	<?php endif; ?>
	<?php if ( fup_can( 'block-user' ) ) : ?>
        <div class="tab-pane fade" id="blocked">
			<?php fup_load_template( 'sections/authors-blocked' ); ?>
        </div>
	<?php endif; ?>
</div>
