<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$profileUser = fup_get_user();

if ( ! $profileUser ) {
	return;
}

?>

<?php if ( fup_is_current_user() ) : ?>
    <nav class="nav-horizontal primary-links">
        <div class="nav-scroll-mask">
            <ul class="nav nav-tabs nav-tabs--pills" role="tablist">
				<?php foreach ( $profileUser->pages as $data ) : ?>
					<?php if ( ! $data['show'] ) {
						continue;
					} ?>
                    <li class="nav-item">
                        <a href="<?php echo esc_url( $data['url'] ) ?>"
                           class="nav-link <?php echo esc_attr( $data['active'] ) ?>"
                           role="tab"><?php echo $data['name'] ?></a>
                    </li>
				<?php endforeach; ?>
            </ul>
        </div>
    </nav>
<?php endif; ?>

<?php if ( ! is_admin() && ( fup_is_main_page() || ! fup_is_current_user_profile() ) ) : ?>
	<?php fup_load_template( 'public' ) ?>
<?php endif; ?>

<?php if ( fup_is_current_user_profile() ) : ?>
	<?php do_action( 'fup_tabs_start' ); ?>

	<?php if ( fup_is_interests_page() && ( fup_can( 'follow-category' ) || fup_can( 'bookmark' ) || fup_can( 'follow-user' ) || fup_can( 'block-user' ) ) ) : ?>
		<?php fup_load_template( 'private' ) ?>
	<?php endif; ?>

	<?php if ( fup_is_settings_page() ) : ?>
		<?php fup_load_template( 'settings' ) ?>
	<?php endif; ?>

	<?php if ( fup_is_styles_page() ) : ?>
		<?php fup_load_template( 'styles' ) ?>
	<?php endif; ?>

	<?php do_action( 'fup_tabs_end' ); ?>

	<?php if ( fup_can( 'publish-post' ) && fup_is_add_article_page() && ! fup_is_publishing_admin_page() ) : ?>
		<?php fup_load_template( 'add-article' ) ?>
	<?php endif; ?>

	<?php if ( fup_can( 'publish-post' ) && fup_is_edit_article_page() && ! fup_is_publishing_admin_page() ) : ?>
		<?php fup_load_template( 'edit-article' ) ?>
	<?php endif; ?>
<?php endif; ?>
