<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php foreach ( $sections as $section ) : ?>
    <div class="svq-section-settings">
		<?php if ( $section->title ) : ?>
            <div class="heading-title">
                <div class="heading-title-content">
                    <span class="heading-title-text">
                      <span class="svq-icon icon-<?php echo esc_attr( $section->icon ) ?> icon--x24"></span>
	                    <?php echo esc_html( $section->title ) ?>
                    </span>
					<?php if ( $section->description ) : ?>
                        <span class="heading-title-info"><?php echo esc_html( $section->description ) ?></span>
					<?php endif; ?>
                </div>
            </div>
		<?php endif; ?>
		<?php $rows = $form->rows( $section->name ) ?>
		<?php foreach ( $rows as $row ): ?>
            <div class="form-row">
				<?php $fields = $form->fields( $row->name ) ?>
				<?php foreach ( $fields as $field ): ?>
                    <div class="settings-item col-md-<?php echo esc_attr( $field->cols ) ?>">
						<?php if ( $field->field === 'input' ) : ?>
                            <span class="settings-label">
                                <?php echo esc_html( $field->label ) ?>
                            </span>
                            <div class="form-action">
								<?php if ( $field->type !== 'file' ) : ?>
                                    <input class="form-control"
                                           name="<?php echo esc_attr( $field->name ) ?>"
                                           type="<?php echo esc_attr( $field->type ) ?>"
                                           value="<?php echo esc_attr( $field->value ) ?>"
                                           placeholder="<?php echo esc_attr( $field->placeholder ) ?>"
                                           accept="<?php echo esc_attr( $field->accept ) ?>"/>
								<?php else : ?>
                                    <div class="svq-comment--media svq-profile-img-form">
                                        <div class="svq-comment--media-el <?php echo( $field->value ? 'has-element' : '' ) ?>">
                                            <div class="svq-comment--el-preview"
                                                 style="background-image: url('<?php echo esc_url( $field->value ) ?>');"></div>

                                            <div class="svq-comment--file">
                                                <label class="svq-comment--file-label"
                                                       for="<?php echo esc_attr( $field->name ) ?>"></label>
                                                <input class="svq-comment--file-input svq-img-input"
                                                       id="<?php echo esc_attr( $field->name ) ?>"
                                                       name="<?php echo esc_attr( $field->name ) ?>"
                                                       type="<?php echo esc_attr( $field->type ) ?>"
													<?php echo( $field->accept ? 'accept="' . esc_attr( $field->accept ) . '"' : '' ) ?>
                                                />
                                                <input class="svq-file-del" type="hidden"
                                                       name="delete-<?php echo esc_attr( $field->name ) ?>" value="0">
                                            </div>
                                            <span class="svq-comment--file-add">


                                                <?php if ( $field->value ) : ?>
                                                    <span class="svq-icon icon-retweet icon--x18"></span>
                                                <?php else: ?>
                                                    <span class="svq-icon icon-cloud-upload icon--x18"></span>
                                                <?php endif; ?>
                                            </span>
											<?php if ( $field->name !== 'avatar' ) : ?>
                                                <span class="svq-comment--file-delete svq-img-del">
                                                    <span class="svq-icon icon-close icon--x18"></span>
                                                </span>
											<?php endif; ?>
                                        </div>
                                    </div>
								<?php endif; ?>
                            </div>
						<?php elseif ( $field->field === 'textarea' ) : ?>
                            <span class="settings-label">
                                <?php echo esc_html( $field->label ) ?>
                            </span>
                            <div class="form-action">
                                    <textarea class="form-control"
                                              name="<?php echo esc_attr( $field->name ) ?>"
                                              rows="3"
                                              placeholder="<?php echo esc_attr( $field->placeholder ) ?>"
                                              cols="50"><?php echo esc_html( $field->value ) ?></textarea>
                            </div>
						<?php elseif ( $field->field === 'switch' ) : ?>
                            <div class="heading-title">
                                <div class="heading-title-content">
                                    <span class="heading-title-text">
                                        <?php if ( $field->icon ) : ?>
                                            <span class="svq-icon icon-<?php echo esc_attr( $field->icon ) ?> icon--x24"></span>
                                        <?php endif; ?>
	                                    <?php echo esc_html( $field->label ) ?>
                                    </span>
                                    <span class="heading-title-info"><?php echo esc_html( $field->placeholder ) ?></span>
                                </div>
                                <div class="heading-title-action">
                                    <label class="switch">
                                        <input type="checkbox"
                                               class="<?php echo( $field->name === 'theme' ? 'typer-toggle-dark' : '' ) ?>"
                                               name="<?php echo esc_attr( $field->name ) ?>"
                                               value="<?php echo esc_attr( $field->value ) ?>"
											<?php echo ( $field->value ) ? 'checked' : '' ?>>
                                        <span></span>
                                    </label>
                                </div>
                            </div>
						<?php elseif ( $field->field === 'radio-colors' ) : ?>
                            <span class="settings-label">
                                <?php echo esc_html( $field->label ) ?>
                            </span>
                            <div class="profile-form svq-form">
								<?php
								$current_color = $field->value;
								if ( ! $current_color ) {
									$current_color = 'bottom';
								}
								?>
								<?php foreach ( fup_colors() as $color => $label ) : ?>
                                    <div class="<?php echo esc_attr( $color ) ?>-color form-check-inline">
                                        <input id="<?php echo esc_attr( $color ) ?>-color-control"
                                               class="profile-cover-overlay"
                                               name="<?php echo esc_attr( $field->name ) ?>" type="radio"
                                               value="<?php echo esc_attr( $color ) ?>"
											<?php echo $current_color === $color ? 'checked' : '' ?>>
                                        <label for="<?php echo esc_attr( $color ) ?>-color-control"><?php echo esc_html( $label ) ?></label>
                                    </div>
								<?php endforeach; ?>
                            </div>
						<?php elseif ( $field->field === 'select' ) : ?>
                            <span class="settings-label">
                                <?php echo esc_html( $field->label ) ?>
                            </span>
                            <div class="form-action">
                                <select name="<?php echo esc_attr( $field->name ) ?>">
									<?php foreach ( $field->select_values as $key => $value ): ?>
                                        <option <?php selected( $field->value, $value ); ?>>
											<?php echo esc_html( $value ); ?>
                                        </option>
									<?php endforeach; ?>
                                </select>
                            </div>
						<?php endif; ?>
                    </div>
				<?php endforeach; ?>
            </div>
		<?php endforeach; ?>
    </div>
<?php endforeach; ?>
