<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title><?php echo $title ?></title>

    <style type="text/css">
        /* Take care of image borders and formatting, client hacks */
        img {
            max-width: 600px;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
            height: auto;
        }

        a img {
            border: none;
        }

        table {
            border-collapse: collapse !important;
        }

        #outlook a {
            padding: 0;
        }

        .ReadMsgBody {
            width: 100%;
        }

        .ExternalClass {
            width: 100%;
        }

        .backgroundTable {
            margin: 0 auto;
            padding: 0;
            width: 100% !important;
        }

        table td {
            border-collapse: collapse;
        }

        .ExternalClass * {
            line-height: 115%;
        }

        .container-for-gmail-android {
            min-width: 600px;
        }

        /* General styling */
        * {
            font-family: Helvetica, Arial, sans-serif;
        }

        body {
            -webkit-font-smoothing: antialiased;
            -webkit-text-size-adjust: none;
            width: 100% !important;
            margin: 0 !important;
            height: 100%;
            color: #242424;
        }

        td {
            font-family: Helvetica, Arial, sans-serif;
            font-size: 14px;
            color: #242424;
            text-align: center;
            line-height: 21px;
        }

        a {
            color: #676767;
            text-decoration: none !important;
        }

        .pull-left {
            text-align: left;
        }

        .pull-right {
            text-align: right;
        }

        .header-lg,
        .header-md,
        .header-sm {
            font-size: 32px;
            font-weight: 700;
            line-height: normal;
            padding: 35px 0 0;
            color: #242424;
        }

        .header-lg {
            padding-bottom: 20px;
        }

        .header-md {
            font-size: 24px;
        }

        .read-more-link {
            font-size: 12px;
            font-weight: 500;
            text-transform: uppercase;
            color: #0B93F6;
        }

        .header-sm {
            padding: 5px 0;
            font-size: 18px;
            line-height: 1.3;
        }

        .content-padding {
            padding: 20px 0 30px;
        }

        .mobile-header-padding-right {
            width: 290px;
            text-align: right;
            padding-left: 10px;
        }

        .mobile-header-padding-left {
            width: 290px;
            text-align: left;
            padding-left: 10px;
        }

        .free-text {
            width: 100% !important;
            padding: 10px 60px 0px;
        }

        .block-rounded {
            border-radius: 5px;
            border: 1px solid #eeeeee;
            vertical-align: top;
        }

        .read-more-button {
            font-size: 15px;
            line-height: 1.4;
            border-radius: 3px;
            display: inline-block;
            outline: 0;
            padding: 15px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #168de9;
            color: #fff;
            padding: 15px 25px;
        }

        .button {
            padding: 30px 0;
        }

        .info-block {
            padding: 0 20px;
            width: 260px;
        }

        .mini-block-container {
            padding: 30px 50px;
            width: 500px;
        }

        .mini-block {
            background-color: #ffffff;
            width: 498px;
            border: 1px solid #cccccc;
            border-radius: 5px;
            padding: 60px 75px;
        }

        .aligncenter,
        div.aligncenter {
            display: block;
            margin: auto;
        }

        .user-img img {
            width: 82px;
            border-radius: 5px;
            border: 1px solid #cccccc;
        }

        .user-img {
            width: 92px;
            text-align: left;
        }

        .user-msg {
            width: 236px;
            font-size: 14px;
            text-align: left;
            font-style: italic;
        }

        .code-block {
            padding: 10px 0;
            border: 1px solid #cccccc;
            color: #4d4d4d;
            font-weight: bold;
            font-size: 18px;
            text-align: center;
        }

        .block-rounded {
            width: 260px;
        }

        .info-img {
            width: 140px;
            border-radius: 5px 0 0 5px;
        }

        .force-width-img {
            width: 480px;
            height: 1px !important;
        }

        .force-width-full {
            width: 600px;
            height: 1px !important;
        }

        .force-width-gmail {
            min-width: 600px;
            height: 0px !important;
            line-height: 1px !important;
            font-size: 1px !important;
        }

        .button-width {
            width: 228px;
        }

    </style>

    <style type="text/css" media="screen">
        @media screen {
            /* Thanks Outlook 2013! */
            * {
                font-family: 'Helvetica Neue', 'Arial', 'sans-serif' !important;
            }
        }
    </style>

    <style type="text/css" media="only screen and (max-width: 480px)">
        /* Mobile styles */
        @media only screen and (max-width: 480px) {

            table[class*="container-for-gmail-android"] {
                min-width: 290px !important;
                width: 100% !important;
            }

            table[class="w320"] {
                width: 320px !important;
            }

            img[class="force-width-gmail"] {
                display: none !important;
                width: 0 !important;
                height: 0 !important;
            }

            a[class="button-width"],
            a[class="button-mobile"] {
                width: 248px !important;
            }

            td[class*="mobile-header-padding-left"] {
                width: 160px !important;
                padding-left: 0 !important;
            }

            td[class*="mobile-header-padding-right"] {
                width: 160px !important;
                padding-right: 0 !important;
            }

            td[class="header-lg"] {
                font-size: 24px !important;
                padding-bottom: 5px !important;
            }

            td[class="header-md"] {
                font-size: 18px !important;
                padding-bottom: 5px !important;
            }

            td[class="content-padding"] {
                padding: 5px 0 30px !important;
            }

            td[class="button"] {
                padding: 5px !important;
            }

            td[class*="free-text"] {
                padding: 10px 18px 30px !important;
            }

            img[class="force-width-img"],
            img[class="force-width-full"] {
                display: none !important;
            }

            td[class="info-block"] {
                display: block !important;
                width: 280px !important;
            }

            td[class="info-img"],
            img[class="info-img"] {
                width: 140px !important;
            }
        }
    </style>
</head>

<body bgcolor="#f7f7f7">
<table align="center" cellpadding="0" cellspacing="0" class="container-for-gmail-android" width="100%"
       bgcolor="#ffffff">
    <tr>
        <td align="left" valign="top" width="100%">
            <table cellspacing="0" cellpadding="0" width="100%">
                <tr>
                    <td width="100%" height="80" valign="top" style="text-align: center; vertical-align:middle;">
                        <!--[if gte mso 9]>
                        <v:rect xmlns:v="urn:schemas-microsoft-com:vml" fill="true" stroke="false"
                                style="mso-width-percent:1000;height:80px; v-text-anchor:middle;">
                            <v:fill type="tile"
                                    src="http://s3.amazonaws.com/swu-filepicker/4E687TRe69Ld95IDWyEg_bg_top_02.jpg"
                                    color="#ffffff"/>
                            <v:textbox inset="0,0,0,0">
                        <![endif]-->

                        <table align="center" cellpadding="0" cellspacing="0" width="600" class="w320">
                            <tr>
                                <td class="pull-left mobile-header-padding-left"
                                    style="vertical-align: middle;">
                                    <a href="">
										<?php if ( $logo ) : ?>
                                            <img width="137" height="47"
                                                 src="<?php echo esc_url( $logo ) ?>"
                                                 alt="<?php echo esc_attr( $title ) ?>">
										<?php else: ?>
											<?php echo esc_html( $title ) ?>
										<?php endif; ?>
                                    </a>
                                </td>
                                <td class="pull-right mobile-header-padding-right" style="color: #4d4d4d;">
									<?php if ( $twitter ): ?>
                                        <a href="<?php echo esc_url( $twitter ) ?>">
                                            <img width="44" height="47"
                                                 src="http://s3.amazonaws.com/swu-filepicker/k8D8A7SLRuetZspHxsJk_social_08.gif"
                                                 alt="twitter"/>
                                        </a>
									<?php endif; ?>
									<?php if ( $facebook ): ?>
                                        <a href="<?php echo esc_url( $facebook ) ?>">
                                            <img width="38" height="47"
                                                 src="http://s3.amazonaws.com/swu-filepicker/LMPMj7JSRoCWypAvzaN3_social_09.gif"
                                                 alt="facebook"/>
                                        </a>
									<?php endif; ?>
                                </td>
                            </tr>
                        </table>

                        <!--[if gte mso 9]>
                        </v:textbox>
                        </v:rect>
                        <![endif]-->
                    </td>
                </tr>
            </table>
        </td>
    </tr>
