<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<tr>
    <td align="center" valign="top" width="100%"
        style="background-color: #ffffff;  border-top: 1px solid #e5e5e5; border-bottom: 1px solid #e5e5e5;">
        <table align="center" cellpadding="0" cellspacing="0" width="600" class="w320" style="margin-bottom: 40px;">

			<?php if ( $content_text ) : ?>
                <tr>
                    <td class="content-padding">
                        <table cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td style="padding: 25px 0 0; text-align: left">
									<?php echo wpautop( $content_text ) ?>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
			<?php endif; ?>

			<?php if ( count( $posts ) ) : ?>
                <tr>
                    <td class="content-padding">
                        <table cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td class="header-lg">
									<?php esc_html_e( 'Top Stories For You', 'front-user-profile' ) ?>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
			<?php endif; ?>
			<?php foreach ( $posts as $post ) : ?>
                <tr>
                    <td style="padding-bottom: 25px;">
                        <table cellpadding="0" cellspacing="0" width="100%"
                               style="border-collapse:separate !important;">
                            <tr>
                                <td class="info-block">
                                    <table cellpadding="0" cellspacing="0" width="100%"
                                           style="border-collapse:separate !important;">
                                        <tr>
                                            <td class="block-rounded">
                                                <table cellpadding="0" cellspacing="0" width="100%">
                                                    <tr>
														<?php if ( get_the_post_thumbnail( $post, 'thumbnail' ) ) : ?>
                                                            <td class="info-img">
                                                                <a href="<?php echo get_the_permalink( $post ) ?>">
																	<?php echo get_the_post_thumbnail( $post, 'thumbnail', [ 'class' => 'skip-lazy' ] ) ?>
                                                                </a>
                                                            </td>
														<?php endif; ?>
                                                        <td style="padding: 15px;">
                                                            <table cellspacing="0" cellpadding="0" width="100%">
                                                                <tr>
                                                                    <td style="text-align:left;">
                                                                        <a href="<?php echo get_the_permalink( $post ) ?>">
                                                                            <span class="header-sm"
                                                                                  style="display: block; margin-bottom: 10px"><?php echo get_the_title( $post ) ?></span>
                                                                        </a>
                                                                        <div style="font-size: 16px;"><?php echo fup_get_excerpt( $post ); ?>
                                                                            ... <a class="read-more-link"
                                                                                   href="<?php echo get_the_permalink( $post ) ?>"><?php esc_html_e( 'Read
                                                                                more', 'front-user-profile' ); ?></a>
                                                                        </div>
                                                                        <div style="margin-top: 6px; font-size: 12px; font-weight: 500; color: #676767;">
																			<?php
																			$author_link = '<a href="' . get_author_posts_url( $post->post_author ) . '" rel="author">' .
																			               get_the_author_meta( 'display_name', $post->post_author ) . '</a>';

																			printf( esc_html__( 'Written by %s', 'front-user-profile' ), $author_link );
																			?>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
			<?php endforeach; ?>
			<?php foreach ( $category_posts as $category_post ): ?>
                <tr>
                    <td class="content-padding">
                        <table cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td class="header-md">
									<?php
									printf( '%1$s <a href="%2$s">%3$s</a>',
										esc_html__( 'New from', 'front-user-profile' ),
										get_category_link( $category_post['category'] ),
										$category_post['category']->name );
									?>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
				<?php foreach ( $category_post['posts'] as $post ) : ?>
                    <tr>
                        <td style="padding-bottom: 25px;">
                            <table cellpadding="0" cellspacing="0" width="100%"
                                   style="border-collapse:separate !important;">
                                <tr>
                                    <td class="info-block">
                                        <table cellpadding="0" cellspacing="0" width="100%"
                                               style="border-collapse:separate !important;">
                                            <tr>
                                                <td class="block-rounded">
                                                    <table cellpadding="0" cellspacing="0" width="100%">
                                                        <tr>
															<?php if ( get_the_post_thumbnail( $post, 'thumbnail' ) ) : ?>
                                                                <td class="info-img">
                                                                    <a href="<?php echo get_the_permalink( $post ) ?>">
																		<?php echo get_the_post_thumbnail( $post, 'thumbnail', [ 'class' => 'skip-lazy' ] ) ?>
                                                                    </a>
                                                                </td>
															<?php endif; ?>
                                                            <td style="padding: 15px;">
                                                                <table cellspacing="0" cellpadding="0" width="100%">
                                                                    <tr>
                                                                        <td style="text-align:left;">
                                                                            <a href="<?php echo get_the_permalink( $post ) ?>">
                                                                                <span class="header-sm"><?php echo get_the_title( $post ) ?></span>
                                                                            </a><br/>
                                                                            <div style="font-weight: bold; margin-bottom: 6px;">
																				<?php
																				$author_link = '<a href="' . get_author_posts_url( $post->post_author ) . '" rel="author">' .
																				               get_the_author_meta( 'display_name', $post->post_author ) . '</a>';

																				printf( esc_html__( 'Written by %s', 'front-user-profile' ), $author_link );
																				?>
                                                                            </div>
																			<?php echo fup_get_excerpt( $post ); ?>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
				<?php endforeach; ?>
			<?php endforeach; ?>

            <tr>
                <td>
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td style="padding-bottom: 25px; padding-top: 40px;">
                                <a class="read-more-button"
                                   href="<?php echo esc_url( $user->pages['activity']['url'] ) ?>">
									<?php esc_html_e( 'Read More in Your Feed', 'front-user-profile' ) ?>
                                </a>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </td>
</tr>
