<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$profileUser = fup_get_user();

if ( ! $profileUser ) {
	return;
}

$customizer_options = get_theme_mods();

$options = [
	'fup_media_profile_type'     => '2',
	'fup_media_panel_type'       => 'title-over',
	'fup_media_theme'            => 'light',
	'fup_media_full_height'      => 'sm',
	'fup_media_image_width'      => 'wide',
	'fup_media_meta_animation'   => 'fadeInUp',
	'fup_media_content_position' => 'middle'
];

foreach ( $options as $option => $default ) {
	if ( is_customize_preview() ) {
		$options[ $option ] = get_theme_mod( $option, $default );
	} else {
		if ( isset( $customizer_options[ $option ] ) && $customizer_options[ $option ] !== '' ) {
			$options[ $option ] = $customizer_options[ $option ];
		} else {
			$options[ $option ] = $default;
		}
	}
}

$panel_classes = [];

$cover_files = get_user_meta( $profileUser->data->ID, 'fup_cover', true );
$coverImage  = null;

$cover_overlay = [];

if ( is_array( $cover_files ) && isset( $cover_files[ get_current_blog_id() ] ) ) {
	$upload_dir = wp_upload_dir();
	$coverImage = $upload_dir['baseurl'] . '/front-user-profile/' . $cover_files[ get_current_blog_id() ];

	$panel_classes[] = 'has-featured-image';

	$current_color = get_user_meta( $profileUser->data->ID, 'fup_cover_overlay', true );
	if ( ! $current_color ) {
		$current_color = 'bottom';
	}

	$cover_overlay[]            = 'svq-overlay';
	$cover_overlay[]            = 'svq-overlay--' . $current_color;
	$options['fup_media_theme'] = 'dark';
}

if ( $options['fup_media_full_height'] !== 'none' && $coverImage ) {
	$panel_classes[] = 'svq-panel--full-height-' . $options['fup_media_full_height'];
} else {
	$panel_classes[] = 'svq-panel--off-height';
}

$panel_classes[] = 'svq-panel--' . $options['fup_media_panel_type'];
$panel_classes[] = 'svq-panel--' . $options['fup_media_theme'];

$header_classes = [];

if ( $options['fup_media_content_position'] === 'center' ) {
	$header_classes[] = 'entry-header--h-center';
} elseif ( $options['fup_media_content_position'] === 'middle' ) {
	$header_classes[] = 'entry-header--v-center';
} elseif ( $options['fup_media_content_position'] === 'middle-center' ) {
	$header_classes[] = 'entry-header--h-center';
	$header_classes[] = 'entry-header--v-center';
}

$panel_classes  = implode( ' ', $panel_classes );
$cover_overlay  = implode( ' ', $cover_overlay );
$header_classes = implode( ' ', $header_classes );

$image_class   = 'svq--' . $options['fup_media_image_width'];
$image_ratio   = 'aspect-ratio-1-1';
$profile_style = 'profile-style-' . $options['fup_media_profile_type'];

$animate_class = '';

if ( $coverImage ) {
	$animate_class = 'will-animate';
}

$settings = fup_get_settings();

?>

<div class="svq-panel <?php echo esc_attr( $panel_classes ) ?>">
	<?php if ( $coverImage && fup_can( 'set-cover' ) ) : ?>
        <figure class="svq-media-image <?php echo esc_attr( $image_class ) ?>">
            <div class="svq-progressive">
                <div class="aspect-ratio-placeholder-fill <?php echo esc_attr( $image_ratio ) ?>"></div>
                <div class="svq-progressive__placeholder-image <?php echo esc_attr( $cover_overlay ) ?>">
                    <img class="svq-progressive__image lazy lazy-is-loaded" src="<?php echo esc_url( $coverImage ) ?>"
                         alt="">
                </div>
            </div>
        </figure>
	<?php endif; ?>

    <header class="entry-header <?php echo esc_attr( $header_classes ) ?>">
        <div class="svq-media-profile <?php echo esc_attr( $profile_style ) ?>">
            <div class="entry-meta sticky_profile">
                <div class="author-avatar <?php echo esc_attr( $animate_class ) ?>"
                     data-message="<?php echo esc_attr( $profileUser->notifications ) ?>"
                     data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
					<?php echo get_avatar( $profileUser->data->ID, '60', '', '', [ 'class' => 'avatar-img' ] ) ?>
                </div>

                <div class="entry-meta__content <?php echo esc_attr( $animate_class ) ?>"
                     data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
                    <duv class="by-line">
                        <h3 class="author"><?php echo esc_html( $profileUser->data->display_name ) ?></h3>
                    </duv>
					<?php if ( ( $profileUser->location['country'] || $profileUser->location['city'] ) && fup_show( 'show-location' ) ): ?>
                        <span class="posted-on">
                            <span class="entry-meta__text">
                              <span class="svq-icon icon-map-marker icon--x18"></span>
	                            <?php echo esc_html( implode( ', ', array_filter( $profileUser->location ) ) ) ?>
                            </span>
                        </span>
					<?php endif; ?>
                </div>

				<?php if ( is_user_logged_in() ) : ?>
					<?php if ( ! fup_is_current_user() ): ?>
                        <div class="entry-meta__action <?php echo esc_attr( $animate_class ) ?>"
                             data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
							<?php if ( fup_can( 'block-user' ) ) : ?>
								<?php
								$currentUserBlocked = fup_get_blocked_authors_ids();
								$blocked            = in_array( (string) $profileUser->data->ID, $currentUserBlocked, true );

								$btn_block_classes = [];
								$btn_block_action  = 'fup-author-block';

								if ( $blocked ) {
									$btn_block_classes[] = 'is-changed';
									$btn_block_action    = 'fup-author-unblock';
								}

								$btn_block_classes = implode( ' ', $btn_block_classes );

								?>

                                <button type="button"
                                        class="btn btn-sm btn-toggle-state <?php echo esc_attr( $btn_block_classes ) ?>"
                                        data-action="<?php echo esc_attr( $btn_block_action ) ?>"
                                        data-target="<?php echo esc_attr( $profileUser->data->ID ) ?>">
                                    <span class="btn--loading-state">
                                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                                    <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                                    </span>
                                    <span class="btn--default-state"><?php esc_html_e( 'Block', 'front-user-profile' ) ?></span>
                                    <span class="btn--active-state"><?php esc_html_e( 'Unblock', 'front-user-profile' ) ?></span>
                                </button>
							<?php endif; ?>
							<?php if ( fup_can( 'follow-user' ) ) : ?>
								<?php
								$currentUserFollowing = fup_get_following_authors_ids();
								$follow               = in_array( (string) $profileUser->data->ID, $currentUserFollowing, true );

								$btn_follow_classes = [];
								$btn_follow_action  = 'fup-author-follow';

								if ( $follow ) {
									$btn_follow_classes[] = 'is-changed';
									$btn_follow_action    = 'fup-author-unfollow';
								}

								$btn_follow_classes = implode( ' ', $btn_follow_classes );

								?>

                                <button type="button"
                                        class="btn btn-light btn-sm btn-toggle-state button-ripple <?php echo esc_attr( $btn_follow_classes ) ?>"
                                        data-action="<?php echo esc_attr( $btn_follow_action ) ?>"
                                        data-target="<?php echo esc_attr( $profileUser->data->ID ) ?>">
                                    <span class="btn--loading-state">
                                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                                    <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                                    </span>
                                    <span class="btn--default-state"><?php esc_html_e( '+ Follow', 'front-user-profile' ) ?></span>
                                    <span class="btn--active-state"><?php esc_html_e( 'Following', 'front-user-profile' ) ?></span>
                                </button>
							<?php endif; ?>
                        </div>
					<?php elseif ( fup_can( 'publish-post' ) ): ?>
						<?php
						if ( fup_is_publishing_admin_page() ) {
							$add_new_article_url = '';

							if ( in_array( 'author', $profileUser->data->roles, true ) || in_array( 'administrator', $profileUser->data->roles, true ) ) {
								$add_new_article_url = admin_url( 'post-new.php' );
							}
						} else {
							$add_new_article_url = $profileUser->add_article_page;
						}
						?>

						<?php if ( $add_new_article_url ) : ?>
                            <div class="entry-meta__action <?php echo esc_attr( $animate_class ) ?>"
                                 data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
                                <a class="btn btn-primary btn-sm btn-toggle-state button-ripple"
                                   href="<?php echo esc_url( $add_new_article_url ) ?>">
                                    <span><?php esc_html_e( '+ New Article', 'front-user-profile' ) ?></span>
                                </a>
                            </div>
						<?php endif; ?>
					<?php endif; ?>
				<?php endif; ?>
            </div>

            <div class="author-bio <?php echo esc_attr( $animate_class ) ?>"
                 data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
				<?php if ( fup_show( 'show-description' ) ) : ?>
                    <span class="entry-meta__text"><?php echo esc_html( $profileUser->data->description ) ?></span>
				<?php endif; ?>
				<?php if ( $profileUser->data->user_url && fup_show( 'show-website' ) ): ?>
                    <a href="<?php echo esc_url( $profileUser->data->user_url ) ?>" class="screen-reader-link">
						<?php echo esc_url( $profileUser->data->user_url ) ?>
                    </a>
				<?php endif; ?>
            </div>

			<?php if ( ( $profileUser->social['twitter'] || $profileUser->social['facebook'] || $profileUser->social['instagram'] || $profileUser->social['linkedin'] ) && fup_show( 'show-social' ) ) : ?>
                <div class="svq-share <?php echo esc_attr( $animate_class ) ?>"
                     data-cssanimate="<?php echo esc_attr( $options['fup_media_meta_animation'] ) ?>">
                    <div class="svq-share__action" role="group">
						<?php if ( $profileUser->social['facebook'] ) : ?>
                            <a class="btn btn-link" href="<?php echo esc_url( $profileUser->social['facebook'] ) ?>">
                                <span class="svq-icon icon-facebook icon--x18"></span>
                            </a>
						<?php endif; ?>

						<?php if ( $profileUser->social['instagram'] ) : ?>
                            <a class="btn btn-link" href="<?php echo esc_url( $profileUser->social['instagram'] ) ?>">
                                <span class="svq-icon icon-instagram icon--x18"></span>
                            </a>
						<?php endif; ?>

						<?php if ( $profileUser->social['twitter'] ) : ?>
                            <a class="btn btn-link" href="<?php echo esc_url( $profileUser->social['twitter'] ) ?>">
                                <span class="svq-icon icon-twitter icon--x18"></span>
                            </a>
						<?php endif; ?>

						<?php if ( $profileUser->social['linkedin'] ) : ?>
                            <a class="btn btn-link" href="<?php echo esc_url( $profileUser->social['linkedin'] ) ?>">
                                <span class="svq-icon icon-linkedin icon--x18"></span>
                            </a>
						<?php endif; ?>
                    </div>
                </div>
			<?php endif; ?>
        </div>
    </header>
</div>
