<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php if ( fup_can( 'follow-user' ) && (int) $post->post_author !== get_current_user_id() ): ?>
	<?php
	$currentUserFollowing = fup_get_following_authors_ids();
	$followed             = in_array( (string) $author->data->ID, $currentUserFollowing, true );

	$btn_classes = [];
	$btn_action  = 'fup-author-follow';

	if ( ! is_user_logged_in() ) {
		$btn_classes[] = 'svq-login-popup login-popup';
	}

	if ( $followed ) {
		$btn_classes[] = 'is-changed';
		$btn_action    = 'fup-author-unfollow';
	}

	$btn_classes = implode( ' ', $btn_classes );

	?>
    <div class="entry-meta__action">
        <a class="btn btn-light btn-sm btn-toggle-state button-ripple <?php echo esc_attr( $btn_classes ) ?>"
           data-action="<?php echo esc_attr( $btn_action ) ?>"
           data-target="<?php echo esc_attr( $author->data->ID ) ?>"
           href="<?php echo wp_login_url( get_permalink() ); ?>">
            <span class="btn--loading-state">
                <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	            <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
            </span>
            <span class="btn--default-state">
                <?php esc_html_e( '+ Follow', 'front-user-profile' ) ?>
            </span>
            <span class="btn--active-state">
                <?php esc_html_e( 'Following', 'front-user-profile' ) ?>
            </span>
        </a>
    </div>
<?php endif; ?>
