<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$bookmarked = false;
global $post;

if ( $post && (int) $post->post_author !== get_current_user_id() ) {
	$bookmarks = fup_get_bookmarked_posts_ids();
	if ( in_array( (string) get_the_ID(), $bookmarks, true ) ) {
		$bookmarked = true;
	}
} else {
	return;
}

$btn_classes = [];
$btn_action  = 'fup-post-bookmark';

if ( ! is_user_logged_in() ) {
	$btn_classes[] = 'login-popup svq-login-popup';
}

if ( $bookmarked ) {
	$btn_classes[] = 'is-changed';
	$btn_action    = 'fup-post-unbookmark';
}

$btn_classes = implode( ' ', $btn_classes );

?>

<div class="entry-meta__action">
    <a href="<?php echo wp_login_url( get_permalink() ); ?>"
       class="btn btn-link btn-sm btn-icon--right btn-toggle-state <?php echo esc_attr( $btn_classes ) ?>"
       data-action="<?php echo esc_attr( $btn_action ) ?>"
       data-target="<?php the_ID() ?>">
    <span class="btn--loading-state">
      <span class="bookmark-text"><?php esc_html_e( 'Saving', 'front-user-profile' ) ?></span>
      <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
    </span>
        <span class="btn--default-state">
      <span class="bookmark-text"><?php esc_html_e( 'Bookmark this article', 'front-user-profile' ) ?></span>
      <span class="svq-icon icon-bookmark icon--x18"></span>
    </span>
        <span class="btn--active-state">
      <span class="bookmark-text"><?php esc_html_e( 'Bookmarked', 'front-user-profile' ) ?></span>
      <span class="svq-icon icon-bookmark-solid icon--x18"></span>
    </span>
    </a>
</div>
