<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;
$author = fup_get_user( $post->post_author );

if ( ! $author ) {
	return [];
}

$last_author = $last_id = get_post_meta( get_the_ID(), '_edit_last', true );

$contributor = false;

if ( $last_author && (int) $last_author !== $author->data->ID ) {
	$contributor = fup_get_user( $last_author );

	if ( $contributor && ! fup_show( 'show-admin-as-contributor' ) && array_intersect( [ 'administrator' ], $contributor->data->roles ) ) {
		$contributor = false;
	}
}

?>

<div class="svq-author-section">
    <div class="author-infobox">
        <div class="entry-meta entry-meta--all">
            <div class="author-avatar avatar-size-md">
                <a href="<?php echo esc_url( $author->pages['activity']['url'] ) ?>" rel="author">
					<?php echo get_avatar( $author->data->ID, '80', '', '', [ 'class' => 'avatar-img' ] ) ?>
                </a>
            </div>
            <div class="entry-meta__content">
                <span class="by-line ">
                    <span class="author">
                        <a href="<?php echo esc_url( $author->pages['activity']['url'] ) ?>"
                           rel="author"><?php echo esc_html( $author->data->display_name ) ?></a>
                    </span>
                </span>
				<?php if ( fup_show( 'show-author-box-member-since' ) ): ?>
                    <span class="posted-on">
                        <span class="entry-meta__text"><?php esc_html_e( 'Member since', 'front-user-profile' ) ?></span>
                        <time class="entry-date published" datetime="<?php echo get_the_date( 'Y-m-d H:i' ); ?>">
                            <?php echo date( get_option( 'date_format' ), strtotime( $author->data->user_registered ) ) ?>
                        </time>
                    </span>
				<?php endif; ?>
            </div>

			<?php

			fup_load_template( 'components/meta-button-follow', [ 'author' => $author, 'post' => $post ] )

			?>

			<?php if ( is_user_logged_in() && (int) $post->post_author === get_current_user_id() ): ?>
                <div class="entry-meta__action">
                    <a class="btn btn-sm btn-link button-ripple"
                       href="<?php echo esc_url( $author->pages['settings']['url'] ) ?>">
                        <span class="btn--default-state">
                            <?php esc_html_e( 'Edit my profile', 'front-user-profile' ) ?>
                        </span>
                    </a>
                </div>
			<?php endif; ?>

        </div>
		<?php if ( $author->data->description && fup_show( 'show-author-box-bio' ) ) : ?>
            <div class="author-bio">
                <span class="entry-meta__text"><?php echo esc_html( $author->data->description ) ?></span>
				<?php if ( $author->data->user_url ) : ?>
                    <a href="<?php echo esc_url( $author->data->user_url ) ?>"
                       class="screen-reader-link"><?php echo $author->data->user_url ?></a>
				<?php endif; ?>
            </div>
		<?php endif; ?>
    </div>

	<?php if ( $contributor && fup_show( 'show-author-box-contributors' ) ) : ?>
        <div class="svq-contributors">
            <div class="heading-title-content">
                <span class="heading-title-text"><?php esc_html_e( 'Contributor', 'front-user-profile' ) ?></span>
            </div>
            <div class="svq-contrib-avatars">
                <div class="author-avatar avatar-size-sm">
                    <a href="<?php echo esc_url( $contributor->pages['activity']['url'] ) ?>" rel="author">
						<?php echo get_avatar( $contributor->data->ID, '80', '', '', [ 'class' => 'avatar-img' ] ) ?>
                    </a>
                </div>
            </div>
        </div>
	<?php endif; ?>

	<?php if ( ( $author->social['facebook'] || $author->social['instagram'] || $author->social['twitter'] || $author->social['linkedin'] ) && fup_show( 'show-author-box-social' ) ) : ?>
        <div class="svq-share">
            <div class="heading-title-content">
                <span class="heading-title-text">
                    <?php echo sprintf( esc_html__( "Do you like %s's articles?", 'front-user-profile' ), $author->data->display_name ) ?>
                    <span class="text-muted"><?php esc_html_e( 'Follow on social!', 'front-user-profile' ) ?></span>
                </span>
            </div>

            <div class="svq-share__action" role="group">
				<?php if ( $author->social['facebook'] ) : ?>
                    <a class="btn btn-link" href="<?php echo esc_url( $author->social['facebook'] ) ?>"
                       target="_blank">
                        <span class="svq-icon icon-facebook icon--x18"></span>
                    </a>
				<?php endif; ?>

				<?php if ( $author->social['instagram'] ) : ?>
                    <a class="btn btn-link" href="<?php echo esc_url( $author->social['instagram'] ) ?>"
                       target="_blank">
                        <span class="svq-icon icon-instagram icon--x18"></span>
                    </a>
				<?php endif; ?>


				<?php if ( $author->social['twitter'] ) : ?>
                    <a class="btn btn-link" href="<?php echo esc_url( $author->social['twitter'] ) ?>"
                       target="_blank">
                        <span class="svq-icon icon-twitter icon--x18"></span>
                    </a>
				<?php endif; ?>

				<?php if ( $author->social['linkedin'] ) : ?>
                    <a class="btn btn-link" href="<?php echo esc_url( $author->social['linkedin'] ) ?>"
                       target="_blank">
                        <span class="svq-icon icon-linkedin icon--x18"></span>
                    </a>
				<?php endif; ?>
            </div>
        </div>
	<?php endif; ?>
</div>
