<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Module
 * @package FUP
 */
class Module extends DB {

	/**
	 * @var array
	 */
	public static $instance = [];

	/**
	 * @var Response
	 */
	protected $response;

	/**
	 * Module constructor.
	 */
	public function __construct() {
		parent::__construct();
		$this->response = new Response();
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		$class = static::class;
		if ( ! isset( self::$instance[ $class ] ) ) {
			self::$instance[ $class ] = new static();
		}

		return self::$instance[ $class ];
	}

	/**
	 * @param $target
	 * @param $target_id
	 * @param null $user_id
	 *
	 * @return bool|false|int
	 * @throws \Exception
	 */
	protected function insertData( $target, $target_id, $user_id = null ) {
		if ( ! $target ) {
			return false;
		}

		$like_without_account = false;

		if ( $target === 'like-article' && fup_can( 'like-article-unauth' ) && ! is_user_logged_in() ) {
			$user_id              = 0;
			$like_without_account = true;
		} else if ( ! $user_id ) {
			$user_id = $this->user->ID;
		}

		$data = [
			'user_id'   => $user_id,
			'target_id' => $target_id,
			'target'    => $target,
			'count'     => 0,
			'site'      => $this->site,
			'since'     => ( new \DateTime( 'now' ) )->format( 'Y-m-d H:i:s' )
		];

		if ( $like_without_account ) {
			$currentCount = $this->selectData( 'like-article', true, $target_id );
			if ( empty( $currentCount ) ) {
				$data['count'] ++;
			} else {
				$data['count'] = $currentCount[0]->count + 1;
			}
		}

		return $this->db->replace(
			$this->tb_profile_data,
			$data
		);
	}

	/**
	 * @param $target
	 * @param bool $reverse
	 * @param bool|int $target_id
	 *
	 * @return array|null|object
	 */
	protected function selectData( $target, $reverse = false, $target_id = false ) {
		if ( ! $target ) {
			return null;
		}

		if ( ! $target_id ) {
			$target_id = $this->user->ID;
		}

		if ( ! $reverse ) {
			$query = "SELECT * FROM `" . $this->tb_profile_data . "` WHERE `user_id` = %d AND `target` = %s AND `site` = %d ORDER BY `since` DESC";
		} else {
			$query = "SELECT * FROM `" . $this->tb_profile_data . "` WHERE `target_id` = %d AND `target` = %s AND `site` = %d ORDER BY `since` DESC";
		}

		return $this->db->get_results(
			$this->db->prepare(
				$query,
				$target_id,
				$target,
				$this->site
			)
		);
	}

	/**
	 * @param $target
	 * @param $target_id
	 *
	 * @return bool|false|int
	 */
	protected function deleteData( $target, $target_id ) {
		if ( ! $target ) {
			return false;
		}

		return $this->db->delete(
			$this->tb_profile_data,
			[
				'user_id'   => $this->user->ID,
				'target_id' => $target_id,
				'target'    => $target,
				'site'      => $this->site
			]
		);
	}

	/**
	 * @param array $new_args
	 *
	 * @return \WP_Query
	 */
	protected function get_posts( $new_args = [] ) {
		$args = [
			'ignore_sticky_posts' => 1,
			'post_type'           => 'post',
			'orderby'             => 'date',
			'order'               => 'DESC'
		];

		$args = array_merge( $args, $new_args );

		return new \WP_Query( $args );
	}

	protected function update_transient( $name, $exclude, $user = true ) {
		if ( $user && is_user_logged_in() ) {
			$name .= '_' . get_current_user_id();
		}

		set_transient( $name, $exclude, 60 * 60 );
	}

}
