<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class LikePost
 * @package FUP
 */
class LikePost extends Module {

	/**
	 * DB target
	 */
	const TARGET = 'like-article';

	/**
	 * @param bool $only_ids
	 *
	 * @return array
	 */
	public function getLiked( $only_ids = false ) {
		$response = [];

		if ( ! fup_can( 'like-article' ) ) {
			return $response;
		}

		$liked = $this->selectData( self::TARGET );

		foreach ( $liked as $item ) {
			$post = get_post( $item->target_id );

			if ( ! $post ) {
				continue;
			}

			if ( $only_ids ) {
				$response[] = $post->ID;
			} else {
				$response[] = $post;
			}
		}

		return $response;
	}

	/**
	 * @param null $post_id
	 *
	 * @return int
	 */
	public function getCount( $post_id = null ) {
		if ( ! $post_id ) {
			return 0;
		}

		$likeData = $this->selectData( self::TARGET, true, $post_id );

		$likes = 0;
		foreach ( $likeData as $like ) {
			if ( (bool) $like->user_id ) {
				$likes ++;
			} else {
				$likes += $like->count;
			}
		}

		return $likes;
	}

	/**
	 * @param $max
	 *
	 * @return array|null|object
	 */
	public function getMostLiked( $max ) {
		global $wpdb;
		$query = "SELECT COUNT(*) as `likes`, `target_id` FROM `" . $wpdb->prefix . 'fup_profile_data' . "` WHERE `target` = %s AND `site` = %d GROUP BY `target_id` ORDER BY `likes` DESC LIMIT %d";

		return $wpdb->get_results(
			$this->db->prepare(
				$query,
				'like-article',
				$this->site,
				$max
			)
		);
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 * @throws \Exception
	 */
	public function addLike( \WP_REST_Request $request ) {
		if ( ! fup_can( 'like-article' ) ) {
			return $this->response
				->error();
		}

		$this->insertData( self::TARGET, $request['id'] );

		return $this->response
			->message( 'post-like' );
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 */
	public function removeLike( \WP_REST_Request $request ) {
		if ( ! fup_can( 'like-article' ) ) {
			return $this->response
				->error();
		}

		$this->deleteData( self::TARGET, $request['id'] );

		return $this->response
			->message( 'post-unlike' );
	}

}
