<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class BookmarkPost
 * @package FUP
 */
class BookmarkPost extends Module {

	/**
	 * DB target
	 */
	const TARGET = 'bookmarked';

	/**
	 * @return array
	 */
	public function getBookmarksIds() {
		$response = [];

		if ( ! fup_can( 'bookmark' ) ) {
			return $response;
		}

		$bookmarks = $this->selectData( self::TARGET );

		foreach ( $bookmarks as $item ) {
			$response[] = $item->target_id;
		}

		return $response;
	}

	/**
	 * @param bool $limit
	 * @param array $exclude
	 *
	 * @return array|\WP_Query
	 */
	public function getBookmarks( $limit = false, $exclude = [] ) {
		if ( ! $limit ) {
			$limits = fup_get_api_limits();
			$limit  = $limits['posts']['initial'];
		}

		$ids = $this->getBookmarksIds();
		$ids = array_diff( $ids, $exclude );
		$ids = array_splice( $ids, 0, $limit );

		$response = [];

		if ( ! empty( $ids ) ) {
			$response = $this->get_posts( [
				'post_status'    => 'publish',
				'post__in'       => $ids,
				'posts_per_page' => $limit
			] );
		}

		$this->update_transient( 'fup_queried_bookmarks', array_merge( $ids, $exclude ) );

		return $response;
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 * @throws \Exception
	 */
	public function addBookmark( \WP_REST_Request $request ) {
		if ( ! fup_can( 'bookmark' ) ) {
			return $this->response
				->error();
		}

		$this->insertData( self::TARGET, $request['id'] );

		return $this->response;
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 */
	public function removeBookmark( \WP_REST_Request $request ) {
		if ( ! fup_can( 'bookmark' ) ) {
			return $this->response
				->error();
		}

		$this->deleteData( self::TARGET, $request['id'] );

		return $this->response;
	}

}
