<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class BlockUser
 * @package FUP
 */
class BlockUser extends Module {

	/**
	 * DB target
	 */
	const TARGET = 'blocked';

	public function getBlockedIds() {
		$response = [];

		if ( ! fup_can( 'block-user' ) ) {
			return $response;
		}

		$blocked = $this->selectData( self::TARGET );

		foreach ( $blocked as $item ) {
			$response[] = $item->target_id;
		}

		return $response;
	}

	/**
	 * @param bool $limit
	 * @param array $exclude
	 *
	 * @return array
	 */
	public function getBlocked( $limit = false, $exclude = [] ) {
		if ( ! $limit ) {
			$limits = fup_get_api_limits();
			$limit  = $limits['authors']['initial'];
		}

		$response = [];

		$profile_page = fup_get_profile_page();

		$ids = $this->getBlockedIds();
		$ids = array_diff( $ids, $exclude );
		$ids = array_slice( $ids, 0, $limit );

		foreach ( $ids as $id ) {
			$user = get_user_by( 'ID', $id );

			if ( ! $user ) {
				continue;
			}

			$data              = new \stdClass();
			$data->id          = $user->ID;
			$data->name        = $user->display_name;
			$data->bio         = $user->description;
			$data->avatar_url  = get_avatar_url( $user->ID, [ 'size' => 120 ] );
			$data->profile_url = trailingslashit( get_permalink( $profile_page ) . $user->user_nicename );

			$response[] = $data;
		}

		$this->update_transient( 'fup_queried_blocked', array_merge( $ids, $exclude ) );

		return $response;
	}

	/**
	 * @param bool $user_id
	 *
	 * @return array
	 */
	public function getBlockersIds( $user_id = false ) {
		$response = [];

		if ( ! fup_can( 'block-user' ) ) {
			return $response;
		}

		$blockers = $this->selectData( self::TARGET, true, $user_id );

		foreach ( $blockers as $item ) {
			$user = get_user_by( 'ID', $item->user_id );

			if ( ! $user ) {
				continue;
			}

			$response[] = $user->ID;
		}

		return $response;
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 * @throws \Exception
	 */
	public function addBlock( \WP_REST_Request $request ) {
		if ( $this->user->id !== $request['id'] ) {
			$this->insertData( self::TARGET, $request['id'] );

			return $this->response
				->message( 'user-block' );
		}

		delete_transient( 'fup_home_feed_posts_' . $this->user->id );

		return $this->response
			->message( __( 'You cannot block yourself', 'front-user-profile' ) )
			->error();
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return Response
	 */
	public function removeBlock( \WP_REST_Request $request ) {
		$this->deleteData( self::TARGET, $request['id'] );

		delete_transient( 'fup_home_feed_posts_' . $this->user->id );

		return $this->response
			->message( 'user-unblock' );
	}

}
