<?php

/**
 * Plugin Name: Front User Profile
 * Description: Adds Front-end User profiles
 * Plugin URI: https://seventhqueen.com
 * Author: SeventhQueen
 * Version: 1.6.7
 * Author URI: https://seventhqueen.com
 *
 * Text Domain: front-user-profile
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'FUP_VERSION', '1.6.7' );

define( 'FUP_FILE', __FILE__ );
define( 'FUP_PLUGIN_BASE', plugin_basename( FUP_FILE ) );
define( 'FUP_PATH', plugin_dir_path( FUP_FILE ) );
define( 'FUP_URL', plugins_url( '/', FUP_FILE ) );
define( 'FUP_CORE_PATH', FUP_PATH . 'core/' );
define( 'FUP_MODULES_PATH', FUP_PATH . 'modules/' );
define( 'FUP_HELPERS_PATH', FUP_PATH . 'helpers/' );
define( 'FUP_ASSETS_PATH', FUP_PATH . 'assets/' );
define( 'FUP_ASSETS_URL', FUP_URL . 'assets/' );
define( 'FUP_API_NAMESPACE', 'fup' );

/*
 * Localization
 */
function fup_load_plugin_textdomain() {
	load_plugin_textdomain( 'front-user-profile', false, basename( __DIR__ ) . '/languages/' );
}

add_action( 'plugins_loaded', 'fup_load_plugin_textdomain' );

// Load global functions
require_once FUP_HELPERS_PATH . 'global/functions.php';

// Init plugin
require_once FUP_CORE_PATH . 'FupPlugin.php';
