<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Response
 * @package FUP
 */
class Response extends \stdClass {

	/**
	 * Response defaults
	 */
	const
		ERROR = 'error',
		SUCCESS = 'success';

	/**
	 * Response constructor.
	 */
	public function __construct() {
		$this->code    = self::SUCCESS;
		$this->message = '';
		$this->data    = [];
	}

	/**
	 * @param array $data
	 *
	 * @return $this
	 */
	public function data( array $data ) {
		$this->data = $data;

		return $this;
	}

	/**
	 * @param string $message
	 *
	 * @return $this
	 */
	public function message( $message = '' ) {
		$this->message = $message;

		return $this;
	}

	/**
	 * @return $this
	 */
	public function error() {
		$this->code = self::ERROR;

		return $this;
	}
}
