<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FormBuilder
 * @package FUP
 */
class FormBuilder extends \stdClass {

	/**
	 * @var array
	 */
	private $sections;

	/**
	 * @var array
	 */
	private $fields;

	/**
	 * FormBuilder constructor.
	 */
	public function __construct() {
		$this->sections = [];
		$this->rows     = [];
		$this->fields   = [];
	}

	/**
	 * @param $title
	 * @param $name
	 * @param null $description
	 * @param $icon
	 *
	 * @return $this
	 */
	public function addSection( $title, $name, $description = null, $icon ) {
		$this->sections[] = (object) [
			'title'       => $title,
			'name'        => $name,
			'description' => $description,
			'icon'        => $icon
		];

		return $this;
	}

	/**
	 * @param $section
	 * @param $name
	 *
	 * @return $this
	 */
	public function addRow( $section, $name ) {
		$this->rows[] = (object) [
			'section' => $section,
			'name'    => $name
		];

		return $this;
	}

	/**
	 * @param $row
	 * @param $cols
	 * @param $label
	 * @param null $placeholder
	 * @param $name
	 * @param $field
	 * @param $type
	 * @param string $value
	 * @param string $accept
	 * @param string $icon
	 * @param array $select_values
	 *
	 * @return $this
	 */
	public function addField( $row, $cols, $label, $placeholder = null, $name, $field, $type, $value = '', $accept = '', $icon = '', $select_values = [] ) {
		$this->fields[] = (object) [
			'row'           => $row,
			'cols'          => $cols,
			'label'         => $label,
			'placeholder'   => $placeholder,
			'name'          => $name,
			'field'         => $field,
			'type'          => $type,
			'value'         => $value,
			'accept'        => $accept,
			'icon'          => $icon,
			'select_values' => $select_values
		];

		return $this;
	}

	/**
	 * @return array
	 */
	public function sections() {
		return $this->sections;
	}

	/**
	 * @param null $section
	 *
	 * @return array
	 */
	public function rows( $section = null ) {
		if ( $section ) {
			$section_rows = [];
			foreach ( $this->rows as $row ) {
				if ( $row->section === $section ) {
					$section_rows[] = $row;
				}
			}

			return $section_rows;
		}

		return $this->rows;
	}

	/**
	 * @param null $row
	 *
	 * @return array
	 */
	public function fields( $row = null ) {
		if ( $row ) {
			$row_fields = [];
			foreach ( $this->fields as $field ) {
				if ( $field->row === $row ) {
					$row_fields[] = $field;
				}
			}

			return $row_fields;
		}

		return $this->fields;
	}

}
