<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class CategoryImage
 * @package FUP
 */
class CategoryImage extends Singleton {

	/**
	 * @var string
	 */
	public $placeholder = FUP_ASSETS_URL . 'img/placeholder.png';

	/**
	 * Init category image field in admin panel
	 */
	public function init() {
		add_action( 'edit_term', [ $this, 'save_image' ] );
		add_action( 'create_term', [ $this, 'save_image' ] );
		add_action( 'category_add_form_fields', [ $this, 'add_image_field' ] );
		add_action( 'category_edit_form_fields', [ $this, 'edit_image_field' ] );
		add_filter( 'manage_edit-category_columns', [ $this, 'image_column_thumb' ] );
		add_filter( 'manage_category_custom_column', [ $this, 'image_column_template' ], 10, 3 );
	}

	/**
	 * Adds image field to category add
	 */
	public function add_image_field() {
		wp_enqueue_media();

		$image_url = $this->placeholder;

		include_once FUP_CORE_PATH . 'admin/templates/add-category-image.php';
	}

	/**
	 * @param $taxonomy
	 *
	 * Adds image field to category edit
	 */
	public function edit_image_field( $taxonomy ) {
		wp_enqueue_media();

		$image       = $this->image_url( $taxonomy->term_id, null );
		$image_url   = $image ?: $this->placeholder;
		$placeholder = $this->placeholder;

		include_once FUP_CORE_PATH . 'admin/templates/edit-category-image.php';
	}

	/**
	 * @param $term_id
	 *
	 * Saves category image
	 */
	public function save_image( $term_id ) {
		if ( isset( $_POST['fup_category_image'] ) ) {
			update_option( 'fup_category_image_' . $term_id, $_POST['fup_category_image'] );
		}
	}

	/**
	 * @param $term_id
	 * @param string $size
	 * @param bool $placeholder
	 *
	 * @return array|false|string
	 */
	public function image_url( $term_id, $size = 'full', $placeholder = true ) {
		$image = get_option( 'fup_category_image_' . $term_id );

		$image_url = '';
		if ( ! empty( $image ) ) {
			$attachment_id = attachment_url_to_postid( $image );
			if ( ! empty( $attachment_id ) ) {
				$image_url = wp_get_attachment_image_src( $attachment_id, $size );
				$image_url = $image_url[0];
			}
		}

		if ( $placeholder ) {
			return $image_url ?: $this->placeholder;
		}

		return $image_url;
	}

	/**
	 * @param $columns
	 *
	 * @return array
	 */
	public function image_column_thumb( $columns ) {
		$new_columns          = array();
		$new_columns['cb']    = $columns['cb'];
		$new_columns['thumb'] = __( 'Image', 'front-user-profile' );

		unset( $columns['cb'] );

		return array_merge( $new_columns, $columns );
	}

	/**
	 * @param $columns
	 * @param $column
	 * @param $id
	 *
	 * @return string
	 */
	public function image_column_template( $columns, $column, $id ) {
		if ( $column === 'thumb' ) {
			$columns = '<span><img src="' . $this->image_url( $id, 'thumbnail' ) . '" alt="' . __( 'Thumb', 'front-user-profile' ) . '" class="wp-post-image" /></span>';
		}

		return $columns;
	}
}
