<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class PostBookmarkShortcode
 * @package FUP
 */
class PostBookmarkShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-bookmark-box';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'post_bookmark' ] );
	}

	public function post_bookmark() {
		ob_start();
		fup_load_template( 'components/post-bookmark' );

		return ob_get_clean();
	}

}
