<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FollowersShortcode
 * @package FUP
 */
class FollowersShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-followers';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'followers' ] );
	}

	/**
	 * Followers template
	 *
	 * @return string
	 */
	public function followers() {
		if ( ! fup_can( 'follow-user' ) ) {
			return '';
		}

		ob_start();
		fup_load_template( 'sections/authors-followers' );

		return ob_get_clean();
	}

}
