<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FollowedAuthorsShortcode
 * @package FUP
 */
class FollowedAuthorsShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-followed-authors';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'followed_authors' ] );
	}

	/**
	 * Followed authors template
	 *
	 * @return string
	 */
	public function followed_authors() {
		if ( ! fup_can( 'follow-user' ) ) {
			return '';
		}

		ob_start();
		fup_load_template( 'sections/authors-following' );

		return ob_get_clean();
	}

}
