<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FollowCategoryShortcode
 * @package FUP
 */
class FollowCategoryShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-follow-category-box';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'follow_category' ] );
	}

	public function follow_category() {
		if ( ! fup_can( 'follow-category' ) ) {
			return '';
		}

		ob_start();
		fup_load_template( 'sections/categories-following' );

		return ob_get_clean();
	}

}
