<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class BookmarksShortcode
 * @package FUP
 */
class BookmarksShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-bookmarked-posts';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'bookmarked_posts' ] );
	}

	/**
	 * Bookmarked posts template
	 *
	 * @return string
	 */
	public function bookmarked_posts() {
		if ( ! fup_can( 'bookmark' ) ) {
			return '';
		}

		ob_start();
		fup_load_template( 'sections/bookmarks' );

		return ob_get_clean();
	}

}
