<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class BlockedAuthorsShortcode
 * @package FUP
 */
class BlockedAuthorsShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-blocked-authors';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'blocked_authors' ] );
	}

	/**
	 * Blocked authors template
	 *
	 * @return string
	 */
	public function blocked_authors() {
		if ( ! fup_can( 'block-user' ) ) {
			return '';
		}

		ob_start();
		fup_load_template( 'sections/authors-blocked' );

		return ob_get_clean();
	}

}
