<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class AuthorBoxShortcode
 * @package FUP
 */
class AuthorBoxShortcode extends Singleton {

	/**
	 * @return string
	 */
	public function get_name() {
		return 'sq-author-box';
	}

	/**
	 * @return string
	 */
	public function get() {
		return '[' . $this->get_name() . ']';
	}

	/**
	 * Init shortcode
	 */
	public function init() {
		add_shortcode( $this->get_name(), [ $this, 'post_author_box' ] );
	}

	/**
	 * Author box template
	 *
	 * @return string
	 */
	public function post_author_box() {
		if ( ! is_single() ) {
			return '';
		}

		ob_start();
		fup_load_template( 'components/author-box' );

		return ob_get_clean();
	}

}
