<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class UpgradeDB
 * @package FUP
 */
class UpgradeDB extends DB {

	/**
	 * @var
	 */
	public static $instance;

	/**
	 * @return null|UpgradeDB
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Run migrations and update version
	 */
	public function run() {
		$this->doUpgrades();
		update_option( 'fup-version', FUP_VERSION );
	}

	/**
	 * Run migration function according to version
	 */
	public function doUpgrades() {
		$old_upgrades = get_option( 'fup-upgrades', [] );

		$upgrades = [
			'1.0.4' => 'upgrade_104',
		];

		$currentVersion = get_option( 'fup-version' );

		foreach ( $upgrades as $version => $function ) {
			if ( ! isset( $old_upgrades[ $version ] ) && version_compare( $currentVersion, $version, '<' ) ) {
				$this->$function();
				$old_upgrades[ $version ] = true;
				update_option( 'fup-upgrades', $old_upgrades );
			}
		}
	}

	private function upgrade_104() {
		$migration = "ALTER TABLE `" . $this->tb_profile_data . "`
					ADD COLUMN `count` INT UNSIGNED DEFAULT 0 AFTER `target`;";

		$this->db->query( $migration );
	}

}
