<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Migration
 * @package FUP
 */
class Migration extends DB {

	/**
	 * Execute migration
	 */
	public function execute() {
		if ( ! get_option( 'fup-version' ) ) {
			$charset_collate = $this->db->get_charset_collate();

			$base_table = "CREATE TABLE IF NOT EXISTS `" . $this->tb_profile_data . "` (
                `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
                `user_id` int(20) unsigned NOT NULL,
                `target_id` int(20) unsigned NOT NULL,
                `target` varchar(30) NOT NULL,
                `status` tinyint(1) DEFAULT 1,
                `site` tinyint(4) unsigned NOT NULL,
                `since` timestamp NOT NULL,
                PRIMARY KEY (`id`),
                UNIQUE KEY `composite_unq` (`user_id`, `target_id`, `target`)
              ) $charset_collate;";

			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			dbDelta( $base_table );
		}

		UpgradeDB::instance()->run();
	}

}
