<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class DB
 * @package FUP
 */
class DB {

	/**
	 * @var \wpdb
	 */
	protected $db;

	/**
	 * @var string
	 */
	protected $tb_profile_data;

	/**
	 * @var \WP_User
	 */
	protected $user;

	/**
	 * @var int
	 */
	protected $site;

	/**
	 * DB constructor.
	 */
	public function __construct() {
		global $wpdb;

		$this->db = $wpdb;

		$this->tb_profile_data = $this->db->prefix . 'fup_profile_data';

		$this->user = wp_get_current_user();
		$this->site = get_current_blog_id();
	}

	/**
	 * @return bool
	 */
	protected function isAuth() {
		return is_user_logged_in();
	}

}
