<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$settings = fup_get_settings();

$show_dark_mode = false;

if ( class_exists( '\TyperPro\Modules' ) && \TyperPro\Modules::instance()->is_active( 'darkmode-module' ) ) {
	$show_dark_mode = true;
}

?>
<div class="fp-settings-page">

    <h1 class="fp-title-page"><?php esc_html_e( 'Front User Profile Settings', 'front-user-profile' ) ?></h1>

    <form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="POST" enctype="multipart/form-data">
        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Profile page', 'front-user-profile' ) ?></h3>
        </div>

        <div class="row">
            <div class="col">
                <div class="form-group">
                    <div class="fup-desc">This is the page used to generate users profile pages. Make sure it includes
                        this
                        shortcode:
                        <pre>[sq-front-profile]</pre>
                    </div>
                    <br>
                    <div>
                        <label for="render-page"><?php esc_html_e( 'Choose Page', 'front-user-profile' ) ?></label>
                        <div>
                            <select name="render-page" id="render-page">
                                <option disabled
                                        selected><?php esc_html_e( 'Select page', 'front-user-profile' ) ?></option>
								<?php foreach ( get_pages() as $page ) : ?>
                                    <option value="<?php echo $page->ID ?>" <?php echo ( (int) $settings['render-page'] === (int) $page->ID ) ? 'selected' : '' ?>>
										<?php echo $page->post_title ?>
                                    </option>
								<?php endforeach; ?>
                            </select>
							<?php if ( ! $settings['render-page'] ) : ?>
                                <button type="submit"
                                        class="button button-default"><?php esc_html_e( 'Generate', 'front-user-profile' ) ?></button>
							<?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-footer-widgets" <?php echo ( $settings['visibility']['show-footer-widgets'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Footer Widgets', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show/Hide footer widgets on Profile Page.
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Posts, categories and authors listing', 'front-user-profile' ) ?></h3>
        </div>

        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label for="cat-displayed"><?php esc_html_e( 'Interest Categories', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many categories to show in the Interests tab.</div>
                    <br>
                    <div>
                        <input type="number" name="categories[initial]" id="cat-displayed"
                               value="<?php echo $settings['display']['categories']['initial'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="cat-more"><?php esc_html_e( 'Interest Categories - Load more', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many categories to load more in the Interests tab.</div>
                    <br>
                    <div>
                        <input type="number" name="categories[more]" id="cat-more"
                               value="<?php echo $settings['display']['categories']['more'] ?>">
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="posts-displayed"><?php esc_html_e( 'Activity Posts', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many posts to show in the Activity tab.</div>
                    <br>
                    <div>
                        <input type="number" name="posts[initial]" id="posts-displayed"
                               value="<?php echo $settings['display']['posts']['initial'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="posts-more"><?php esc_html_e( 'Activity Posts - Load more', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many posts to load more in the Activity tab.</div>
                    <br>
                    <div>
                        <input type="number" name="posts[more]" id="posts-more"
                               value="<?php echo $settings['display']['posts']['more'] ?>">
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="authors-displayed"><?php esc_html_e( 'Followed/Blocked Authors', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many authors to show in the Interests tab.</div>
                    <br>
                    <div>
                        <input type="number" name="authors[initial]" id="authors-displayed"
                               value="<?php echo $settings['display']['authors']['initial'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="authors-more"><?php esc_html_e( 'Followed/Blocked - Load more', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">How many authors to load more in the Interests tab.</div>
                    <br>
                    <div>
                        <input type="number" name="authors[more]" id="authors-more"
                               value="<?php echo $settings['display']['authors']['more'] ?>">
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Modules options', 'front-user-profile' ) ?></h3>
        </div>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="publish-post" <?php echo ( $settings['functions']['publish-post'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Publish Post', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Allow users to post articles. Check "Frontend publishing options" for more
                        settings.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="like-article" <?php echo ( $settings['functions']['like-article'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Like Post', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Enable users to like articles. It will show on article page in the social
                        share
                        area.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="like-article-unauth" <?php echo ( $settings['functions']['like-article-unauth'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Like Post (for unauthenticated users)', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Allows unauthenticated users to like posts - works only if the "Like Post"
                        option is
                        enabled. (Not Recommended)
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="follow-user" <?php echo ( $settings['functions']['follow-user'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Follow User', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">
                        Enable users to follow other users from their profile.
                        This will add an "AUTHORS FEED" tab to users profile showing posts from the followed authors.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="block-user" <?php echo ( $settings['functions']['block-user'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Block User', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Enable users to block other users from their profile.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="follow-category" <?php echo ( $settings['functions']['follow-category'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Follow Category', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Enable users to follow categories. Interests - My interests tab will show on
                        users
                        profiles.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-sub-category" <?php echo ( $settings['functions']['show-sub-category'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Allow Follow Subcategories', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Allow users to follow subcategories.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="bookmark" <?php echo ( $settings['functions']['bookmark'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Bookmark Post', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Enable users to bookmark posts. A bookmark icon will show on article lists and
                        article
                        page.
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Frontend publishing options', 'front-user-profile' ) ?></h3>
        </div>

        <div class="row">
            <div class="col">
                <div><b>Admin editor:</b> users will be redirected in the admin panel (Default) <br><b>Custom
                        editor:</b> you
                    can use a shortcode from a
                    plugin like "User Frontend"
                </div>
                <div><i>Notice: If "Admin" editor is selected, only users that have "Author" role will be able to post
                        articles.</i></div>
                <br>
                <div><b>PLEASE NOTE: Editing any post previously created with Gutenberg using other text editors will
                        case the
                        Gutenberg blocks to break! This will have an impact only when you try to edit that post again
                        using
                        Gutenberg.</b></div>
                <br>

                <div class="form-group">
                    <select name="editor" id="render-page">
                        <option disabled selected><?php esc_html_e( 'Select editor', 'front-user-profile' ) ?></option>
						<?php foreach ( $settings['editor'] as $name => $status ) : ?>
                            <option value="<?php echo $name ?>" <?php echo $status ? 'selected' : '' ?>>
								<?php echo ucfirst( $name ) ?>
                            </option>
						<?php endforeach; ?>
                    </select>
                </div>

                <div class="row">
                    <div class="col">
                        <div class="form-group">
                            <label for="add-article-shortcode"><?php esc_html_e( 'Add article page shortcode', 'front-user-profile' ) ?></label>
                            <div class="fup-desc">Applies only when the method is set to "Custom"</div>
                            <br>
                            <textarea id="add-article-shortcode" name="add-article-shortcode"
                                      cols="46"><?php echo $settings['editor-custom']['add-article-shortcode'] ?></textarea>
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for="edit-article-shortcode"><?php esc_html_e( 'Edit article page shortcode', 'front-user-profile' ) ?></label>
                            <div class="fup-desc">Applies only when the method is set to "Custom"</div>
                            <br>
                            <textarea id="edit-article-shortcode" name="edit-article-shortcode"
                                      cols="46"><?php echo $settings['editor-custom']['edit-article-shortcode'] ?></textarea>
                        </div>
                    </div>
                    <div class="col"></div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Profile options', 'front-user-profile' ) ?></h3>
        </div>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="set-cover" <?php echo ( $settings['functions']['set-cover'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Profile Cover', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Allow users to set a cover for their profile.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="drafts" <?php echo ( $settings['visibility']['drafts'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Drafts', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show user drafts on their profile page, under Activity tab.</div>
                </div>
				<?php if ( $show_dark_mode ) : ?>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" value=""
                                   name="dark-mode" <?php echo ( $settings['functions']['dark-mode'] ) ? 'checked' : '' ?>>
							<?php esc_html_e( 'Dark Mode Switch', 'front-user-profile' ) ?>
                        </label>
                        <div class="fup-desc">Allow users to set Dark mode for the site.</div>
                    </div>
				<?php endif; ?>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-social" <?php echo ( $settings['visibility']['show-social'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Social Icons', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show social icons on profile page.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-location" <?php echo ( $settings['visibility']['show-location'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Location', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show user set location on profile page.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-website" <?php echo ( $settings['visibility']['show-website'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Website', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show user's website on profile page.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-description" <?php echo ( $settings['visibility']['show-description'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Description', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show user's description on profile page.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-edit-post-btn" <?php echo ( $settings['visibility']['show-edit-post-btn'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Edit Post Button', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show edit post button for user's posts.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-delete-post-btn" <?php echo ( $settings['visibility']['show-delete-post-btn'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Delete Post Button', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show delete post button for user's posts. (Only shown in his profile)</div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Author box options', 'front-user-profile' ) ?></h3>
        </div>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-author-box" <?php echo ( $settings['visibility']['show-author-box'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Author Box', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show author box on single post.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-author-box-member-since" <?php echo ( $settings['visibility']['show-author-box-member-since'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Member Since Date', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show author's join date.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-author-box-bio" <?php echo ( $settings['visibility']['show-author-box-bio'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Bio', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show author's bio inside author box.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-author-box-social" <?php echo ( $settings['visibility']['show-author-box-social'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Social Icons', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show social icons inside author box.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-author-box-contributors" <?php echo ( $settings['visibility']['show-author-box-contributors'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Contributors', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Show contributors inside author box.</div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="show-admin-as-contributor" <?php echo ( $settings['visibility']['show-admin-as-contributor'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Show Admin as Contributor', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">Allow administrators to show up as contributors.</div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Notifications options', 'front-user-profile' ) ?></h3>
        </div>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="comments" <?php echo ( $settings['notifications']['comments'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Subscribe to comments', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">
                        Notify users via email whenever a new comment is posted.
                        <br>
                        When posting a comment, users will have the option to enable notifications for that post.
                    </div>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" value=""
                               name="digest" <?php echo ( $settings['notifications']['digest'] ) ? 'checked' : '' ?>>
						<?php esc_html_e( 'Weekly digest', 'front-user-profile' ) ?>
                    </label>
                    <div class="fup-desc">
                        Users will receive an email with the latest posts based on categories interest and followed
                        authors.
                        <br>
                        You can customize the template below.
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Weekly digest email template options', 'front-user-profile' ) ?></h3>
        </div>

        <div>
            <h4><?php esc_html_e( 'Header', 'front-user-profile' ) ?></h4>
        </div>

        <div class="row">
            <div class="col">
                <div class="form-group">
                    <label for="logo"><?php esc_html_e( 'Logo Image URL', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">
                        Used in the email header.
                    </div>
                    <br>
                    <div>
                        <input type="text" name="logo" id="logo" value="<?php echo $settings['email']['logo'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="title"><?php esc_html_e( 'Title', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">
                        Used in the email header when no logo image is added.
                    </div>
                    <br>
                    <div>
                        <input type="text" name="title" id="logo" value="<?php echo $settings['email']['title'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="fb"><?php esc_html_e( 'Facebook URL', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">
                        Used in the email header. Shows a Facebook icon
                    </div>
                    <br>
                    <div>
                        <input type="text" name="facebook" id="fb" value="<?php echo $settings['email']['facebook'] ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label for="tw"><?php esc_html_e( 'Twitter URL', 'front-user-profile' ) ?></label>
                    <div class="fup-desc">
                        Used in the email header. Shows a Twitter icon
                    </div>
                    <br>
                    <div>
                        <input type="text" name="twitter" id="tw" value="<?php echo $settings['email']['twitter'] ?>">
                    </div>
                </div>
            </div>
        </div>

        <br>

        <h4><?php esc_html_e( 'Content before feed', 'front-user-profile' ) ?></h4>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <div class="fup-desc">
						<?php esc_html_e( 'You can use the following placeholders:', 'front-user-profile' ) ?>
                        {{firstname}},
                        {{lastname}}
                    </div>
                    <p>
						<?php wp_editor( stripslashes( $settings['email']['content_text'] ), 'content_text', [
							'teeny'         => true,
							'textarea_rows' => 15,
							'tabindex'      => 1
						] ); ?>
                    </p>
                </div>
            </div>
        </div>

        <h4><?php esc_html_e( 'Content after feed', 'front-user-profile' ) ?></h4>
        <div class="row">
            <div class="col">
                <div class="form-group">
                    <p>
						<?php wp_editor( stripslashes( $settings['email']['footer_text'] ), 'footer_text', [
							'teeny'         => true,
							'textarea_rows' => 15,
							'tabindex'      => 1
						] ); ?>
                    </p>
                </div>
            </div>
        </div>

        <br>

        <hr>

        <div>
            <h3 class="fp-subtitle-page"><?php esc_html_e( 'Email preview', 'front-user-profile' ) ?></h3>
        </div>
        <div class="row">
            <div class="col">
                <p><?php esc_html_e( 'Please save your options before previewing or sending the email template.' ) ?></p>

                <div class="form-group">
                    <a href="<?php echo add_query_arg( 'preview-digest', '1', site_url() ) ?>"
                       class="button button-secondary" target="_blank">
						<?php esc_html_e( 'Preview e-mail template', 'front-user-profile' ) ?>
                    </a>
                </div>

                <div class="form-group">
                    <input type="email" form="test-digest" name="test-email" placeholder="example@example.com" required>
                    <button type="submit" form="test-digest" class="button button-secondary button-grouped">
						<?php esc_html_e( 'Test', 'front-user-profile' ) ?>
                    </button>
                </div>
            </div>
        </div>

        <hr>

        <input type="hidden" name="action" value="fup_settings">
        <button type="submit" class="button button-primary"><?php esc_html_e( 'Save', 'front-user-profile' ) ?></button>

    </form>

    <form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" id="test-digest">
        <input type="hidden" name="action" value="fup_digest">
    </form>

</div>
