<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Rewrites
 * @package FUP
 */
class Rewrites extends Singleton {

	/**
	 * Init
	 */
	public function init() {
		add_filter( 'query_vars', [ $this, 'query_vars' ] );
		add_filter( 'page_rewrite_rules', [ $this, 'rewrite_rules' ] );
	}

	/**
	 * @param $vars
	 *
	 * @return array
	 */
	public function query_vars( $vars ) {
		$vars[] = 'author_slug';
		$vars[] = 'sub_page';

		return $vars;
	}

	/**
	 * @param $rules
	 *
	 * @return array
	 */
	public function rewrite_rules( $rules ) {
		$page = fup_get_profile_page();
		if ( $page === null ) {
			return $rules;
		}

		$tc_rule = [
			$page->post_name . '/([^/]+)/?([^/]+)?/?' => 'index.php?pagename=' . $page->post_name . '&author_slug=$matches[1]&sub_page=$matches[2]',
		];

		return array_merge( $tc_rule, $rules );
	}

}
