<?php

namespace FUP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class CustomizerOptions
 * @package FUP
 */
class CustomizerOptions extends Singleton {

	/**
	 * FupPlugin constructor.
	 */
	public function __construct() {
		parent::__construct();

		add_filter( 'typer_theme_settings', [ $this, 'settings' ], 20, 2 );
	}

	/**
	 * @param $sq
	 * @param $panel
	 *
	 * @return mixed
	 */
	public function settings( $sq, $panel ) {
		$section  = 'svq_section_fup';
		$img_path = get_template_directory_uri() . '/assets/img/wp-customizer/';

		$sq['sec'][ $section ] = array(
			'title'    => esc_html__( 'Front User Profile', 'front-user-profile' ),
			'panel'    => $panel,
			'priority' => 1001
		);

		$sq['set']['fup_media_profile_type'] = array(
			'section'     => $section,
			'type'        => 'sq-control-radio-image',
			'choices'     => [
				'1' => [
					'img' => $img_path . 'style-1.svg',
					'alt' => esc_html__( 'Style 1', 'front-user-profile' )
				],
				'2' => [
					'img' => $img_path . 'style-2.svg',
					'alt' => esc_html__( 'Style 2', 'front-user-profile' )
				]
			],
			'default'     => '2',
			'title'       => esc_html__( 'Profile type', 'front-user-profile' ),
			'description' => esc_html__( 'Choose your profile style', 'front-user-profile' )
		);


		$sq['set']['fup_media_panel_type'] = array(
			'section'     => $section,
			'type'        => 'sq-control-radio-image',
			'choices'     => [
				'title-over' => [
					'img' => $img_path . 'title-over-image.svg',
					'alt' => esc_html__( 'Over image', 'front-user-profile' )
				],
				'half'       => [
					'img' => $img_path . 'title-on-left-image.svg',
					'alt' => esc_html__( 'Left of image', 'front-user-profile' )
				]
			],
			'default'     => 'title-over',
			'title'       => esc_html__( 'Media panel width', 'front-user-profile' ),
			'description' => esc_html__( 'Choose.', 'front-user-profile' ),
		);

		$sq['set']['fup_media_full_height'] = array(
			'section'     => $section,
			'type'        => 'select',
			'choices'     => [
				'none' => esc_html__( 'Off', 'front-user-profile' ),
				'sm'   => esc_html__( 'Up to Mobile', 'front-user-profile' ),
				'md'   => esc_html__( 'Up to Tablet', 'front-user-profile' ),
				'lg'   => esc_html__( 'Up to Desktop', 'front-user-profile' )
			],
			'default'     => 'sm',
			'title'       => esc_html__( 'Media panel height', 'front-user-profile' ),
			'description' => esc_html__( 'When should it be full height? (up to)', 'front-user-profile' )
		);

		$sq['set']['fup_media_content_position'] = array(
			'section' => $section,
			'type'    => 'sq-control-radio-image',
			'choices' => [
				'default' => [
					'img' => $img_path . 'title-align-default.svg',
					'alt' => esc_html__( 'Bottom', 'front-user-profile' )
				],
				'middle'  => [
					'img' => $img_path . 'title-center-vertically.svg',
					'alt' => esc_html__( 'Middle', 'front-user-profile' )
				]
			],
			'default' => 'middle',
			'title'   => esc_html__( 'Alignment', 'front-user-profile' )
		);

		$sq['set']['fup_media_image_width'] = array(
			'section'     => $section,
			'type'        => 'sq-control-radio-image',
			'choices'     => [
				'wide'       => [
					'img' => $img_path . 'cover-image-wide.svg',
					'alt' => esc_html__( 'Wide', 'front-user-profile' )
				],
				'full-width' => [
					'img' => $img_path . 'cover-image-full-width.svg',
					'alt' => esc_html__( 'Full width', 'front-user-profile' )

				]
			],
			'default'     => 'full-width',
			'title'       => esc_html__( 'Image width', 'front-user-profile' ),
			'description' => esc_html__( 'Cover image width', 'front-user-profile' )
		);

		$sq['set']['fup_media_meta_animation'] = array(
			'section'     => $section,
			'type'        => 'select',
			'choices'     => [
				'none'       => esc_html__( 'None', 'front-user-profile' ),
				'fadeIn'     => esc_html__( 'FadeIn', 'front-user-profile' ),
				'fadeInUp'   => esc_html__( 'FadeInUp', 'front-user-profile' ),
				'fadeInDown' => esc_html__( 'FadeInDown', 'front-user-profile' ),
			],
			'default'     => 'fadeInUp',
			'title'       => esc_html__( 'Meta animation', 'front-user-profile' ),
			'description' => esc_html__( 'Choose your animation type', 'front-user-profile' )
		);

		$sq['set']['fup_custom_feed'] = array(
			'section'     => $section,
			'type'        => 'switch',
			'choices'     => [
				'1' => esc_html__( 'On', 'front-user-profile' ),
				'0' => esc_html__( 'Off', 'front-user-profile' ),
			],
			'default'     => '1',
			'title'       => esc_html__( 'Homepage feed', 'front-user-profile' ),
			'description' => esc_html__( 'Custom feed section on homepage', 'front-user-profile' )
		);

		return $sq;
	}
}


