<?php

namespace Seventhqueen\Typer;

\Typer_Assets::instance()->enqueue_swiper();

global $wpdb;
$q = $wpdb->get_results(
	$wpdb->prepare(
		"SELECT `meta_value` FROM {$wpdb->prefix}postmeta " .
		"WHERE `post_id` = %d " .
		"AND `meta_key` LIKE %s",
		[ get_the_ID(), '_sq_post_gallery%' ]
	) );

$gallery = [];

foreach ( $q as $item ) {
	if ( $item->meta_value && wp_get_attachment_url( $item->meta_value ) ) {
		$gallery[] = $item->meta_value;
	}
}

if ( empty( $gallery ) || ! is_array( $gallery ) ) {
	return;
}

$overlay_classes = [];
$overlay         = typer()->get_blog_option( 'media_gallery_overlay' );
$overlay_show    = typer()->get_blog_option( 'media_gallery_overlay_show' );

if ( $overlay !== 'none' && in_array( $overlay_show, [ 'single', 'both' ] ) ) {
	$overlay_classes[] = 'svq-overlay svq-overlay--' . $overlay;
}

$overlay_classes = implode( ' ', $overlay_classes );

$item_style = typer()->get_blog_option( 'media_gallery_item_width' );

$item_class = '';

if ( $item_style === 'wide' ) {
	$item_class = 'svq-gallery__item-wide';
} elseif ( $item_style === 'portrait' ) {
	$item_class = 'svq-gallery__item-portrait';
}

$view  = 0;
$count = 0;
if ( ! empty( $gallery ) ) {
	$view = count( $gallery );
	if ( $view > 5 ) {
		$count = $view - 5;
		$view  = 'more';
	}
}

$slider_classes   = [];
$slider_classes[] = sprintf( 'svq--%s', typer()->get_blog_option( 'media_gallery_width' ) );
$slider_classes[] = 'svq-gallery--view-' . $view;
$slider_classes   = implode( ' ', $slider_classes );

$nav_class      = '';
$title_position = typer()->get_blog_option( 'media_title_position' );

if ( $title_position === 'title-over' ) {
	$title_alignment = typer()->get_blog_option( 'media_title_over_alignment' );

	if ( $title_alignment === 'middle' || $title_alignment === 'middle-center' ) {
		$nav_class = 'svq-control-bottom';
	}
}

?>


<?php \Typer_Assets::instance()->enqueue_fancybox() ?>

<div class="svq-gallery-slider <?php echo esc_attr( $slider_classes ) ?>" data-more="<?php echo esc_attr( $count ) ?>">
	<div class="swiper-wrapper">
		<?php foreach ( $gallery as $key ) : ?>
			<div class="svq-gallery__item swiper-slide <?php echo esc_attr( $item_class ) ?>">
				<div class="svq-gallery__image-wrapp <?php echo esc_attr( $overlay_classes ) ?>">
					<a href="<?php echo esc_url( wp_get_attachment_image_url( $key, 'large' ) ) ?>"
					   data-elementor-open-lightbox="no"
					   data-fancybox="gallery-<?php the_ID() ?>"
					   data-caption="<?php echo esc_attr( wp_get_attachment_caption( $key ) ) ?>">
						<?php

						echo wp_get_attachment_image(
							$key,
							'full',
							false,
							[
								'class'           => 'svq-gallery__image',
								'data-object-fit' => 'cover'
							] )

						?>
						<span class="svq-img-loader"></span>
						<noscript>
							<?php

							echo wp_get_attachment_image(
								$key,
								'full',
								false,
								[ 'class' => 'skip-lazy' ]
							)

							?>
						</noscript>
					</a>
				</div>
			</div>
		<?php endforeach; ?>
	</div>

	<div class="swiper-pagination"></div>

	<div class="svq-gallery-control svq-gallery-control-prev <?php echo esc_attr( $nav_class ) ?>"></div>
	<div class="svq-gallery-control svq-gallery-control-next <?php echo esc_attr( $nav_class ) ?>"></div>
</div>
