<?php

namespace Seventhqueen\Typer;

global $post;

/*
 * Panel classes
 */

$panel_classes = [];

$has_media = typer()->has_media();

if ( ! get_post_format() && ! typer()->get_blog_option( 'media_image_enabled' ) ) {
	$has_media = false;
}

$full_screen_options = [
	2 => 'sm',
	3 => 'md',
	4 => 'lg'
];

$title_position = typer()->get_blog_option( 'media_title_position' );

if ( $has_media ) {
	$panel_classes[] = 'has-featured-image';
	$panel_classes[] = 'svq-panel--' . $title_position;
	$panel_classes[] = 'svq-panel--' . typer()->get_blog_option( 'media_content_color' );

	$full_screen = typer()->get_blog_option( 'media_fullscreen' );

	if ( (int) $full_screen && isset( $full_screen_options[ $full_screen ] ) ) {
		$panel_classes[] = 'svq-panel--full-height-' . $full_screen_options[ $full_screen ];
	} else {
		$panel_classes[] = 'svq-panel--off-height';
	}

	if ( get_post_format() === 'video' ) {
		$video_type = get_post_meta( get_the_ID(), '_sq_post_video_type', true );

		if ( $video_type === 'hosted' && get_post_meta( get_the_ID(), '_sq_post_video_illustration', true ) ) {
			$panel_classes[] = 'has-illustration-video';
		}
	}
} else {
	$panel_classes[] = 'svq-panel--light';
	$panel_classes[] = 'svq-panel--off-height';
}

$panel_classes = implode( ' ', $panel_classes );

/*
 * Header classes
 */

$header_classes   = [];
$header_classes[] = 'entry-header--' . typer()->get_blog_option( 'media_title_size' );

if ( $title_position === 'title-over' ) {
	$alignment_slug = 'media_title_over_alignment';
} elseif ( $title_position === 'half' ) {
	$alignment_slug = 'media_title_left_alignment';
} else {
	$alignment_slug = 'media_title_above_below_alignment';
}

$title_alignment = typer()->get_blog_option( $alignment_slug );

if ( $title_alignment === 'center' ) {
	$header_classes[] = 'entry-header--h-center';
} elseif ( $title_alignment === 'middle' ) {
	$header_classes[] = 'entry-header--v-center';
} elseif ( $title_alignment === 'middle-center' ) {
	$header_classes[] = 'entry-header--h-center';
	$header_classes[] = 'entry-header--v-center';
}

$header_classes = implode( ' ', $header_classes );

/**
 * Content classes
 */

$content_classes = [];

if ( $has_media && $title_position !== 'half' && typer()->get_blog_option( 'media_panel_fade_scroll' ) ) {
	$content_classes[] = 'fade-on-scroll';
}

$content_classes = implode( ' ', $content_classes );

?>

<div class="svq-panel <?php echo esc_attr( $panel_classes ) ?>">
	<?php
	if ( ! get_post_format() && typer()->get_blog_option( 'media_image_enabled' ) ) {
		typer()->get_template_part( 'template-parts/content/panel/image' );
	} elseif ( in_array( get_post_format(), [ 'quote', 'audio', 'image' ] ) ) {
		typer()->get_template_part( 'template-parts/content/panel/image' );
	} else if ( get_post_format() === 'video' ) {
		typer()->get_template_part( 'template-parts/content/panel/video' );
	} else if ( get_post_format() === 'gallery' ) {
		typer()->get_template_part( 'template-parts/content/panel/gallery' );
	}

	?>

	<header class="entry-header <?php echo esc_attr( $header_classes ) ?>">
		<div class="entry-header-content <?php echo esc_attr( $content_classes ) ?>">
			<?php

			if ( in_array( typer()->get_blog_option( 'media_catbread_type' ), [
				'category',
				'category-breadcrumb'
			] ) ) {
				typer()->get_categories_nav();
			}

			if ( in_array( typer()->get_blog_option( 'media_catbread_type' ), [
				'breadcrumbv',
				'category-breadcrumb'
			] ) ) {
				typer()->get_breadcrumbs();
			}

			$quote = '';
			if ( get_post_format() === 'quote' ) {
				$quote = \Typer_Assets::instance()->get_content_quote( apply_filters( 'the_content', $post->post_content ) );
				add_filter( 'the_content', [ \Typer_Assets::instance(), 'remove_first_content_quote' ] );
			}

			?>

			<?php if ( ! $quote ) : ?>
				<h1 class="entry-title">
					<?php if ( $has_media ): ?>
						<span class="will-animate d-block" data-cssanimate="fadeIn">
							<?php the_title() ?>
						</span>
					<?php else : ?>
						<?php the_title() ?>
					<?php endif; ?>
				</h1>
			<?php else: ?>
				<?php typer()->get_template_part( 'template-parts/content/panel/quote', null, compact( 'quote' ) ) ?>
			<?php endif; ?>

			<?php if ( get_post_format() === 'audio' ) : ?>
				<?php typer()->get_template_part( 'template-parts/content/panel/audio' ) ?>
			<?php endif; ?>

			<?php if ( typer()->get_blog_option( 'media_meta_show' ) ) : ?>
				<?php typer()->get_template_part( 'template-parts/content/entry-meta' ) ?>
			<?php endif; ?>
		</div>
	</header>

	<?php if ( typer()->get_blog_option( 'media_shapes_show' ) ) : ?>
		<?php typer()->get_template_part( 'template-parts/content/panel/shapes' ) ?>
	<?php endif; ?>
</div>
