<?php
/**
 * Template part for displaying the page content when a 404 error has occurred
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

$image = typer()->get_option( '404_image' );

if ( ! $image ) {
	$image = get_template_directory_uri() . '/assets/img/404_page_not_found.png';
}

?>

<section class="error">
	<div class="page-content">
		<div class="row">
			<div class="col-md-12 text-center">
				<img
					src="<?php echo esc_url( $image ); ?>"
					class="placeholder-404-img"
					alt="404">
			</div>

			<div class="col-md-12 text-center">
				<h1 class="article-title font-weight-black mb-4 mt-8"><?php esc_html_e( 'Ooooops', 'typer' ); ?></h1>

				<h6 class="mb-8"><?php echo esc_html( typer()->get_option( '404_message' ) ); ?></h6>
				<?php get_search_form(); ?>
			</div>
		</div>
	</div>
</section>
