<?php

namespace Seventhqueen\Typer;

global $post;

$meta_classes = '';

if ( typer()->has_media() ) {
	$meta_classes .= 'will-animate';
}

$options = typer()->get_blog_option( 'media_meta_items' );

$show_avatar  = typer()->get_post_data( 'show_meta_avatar', in_array( 'avatar', $options, true ) );
$show_author  = typer()->get_post_data( 'show_meta_author', in_array( 'author', $options, true ) );
$show_date    = typer()->get_post_data( 'show_meta_date', in_array( 'date', $options, true ) );
$show_reading = typer()->get_post_data( 'show_meta_reading', in_array( 'reading', $options, true ) );

?>

<div class="entry-meta <?php echo esc_attr( $meta_classes ) ?>"
     data-cssanimate="<?php echo esc_attr( typer()->get_blog_option( 'media_meta_animation' ) ) ?>">

	<?php if ( $show_avatar ) : ?>
		<div class="author-avatar">
			<a href="<?php echo esc_url( get_author_posts_url( $post->post_author ) ); ?>" rel="author">
				<?php echo get_avatar( $post->post_author, '60', '', get_the_author_meta( 'display_name', $post->post_author ), [ 'class' => 'avatar-img' ] ) ?>
			</a>
		</div>
	<?php endif; ?>

	<div class="entry-meta__content">
		<?php if ( $show_author ) : ?>
			<span class="by-line">
	            <span class="author">
		             <?php
		             $author_link = '<a href="' . get_author_posts_url( $post->post_author ) . '" rel="author">' .
		                            get_the_author_meta( 'display_name', $post->post_author ) . '</a>';
		             printf( esc_html__( 'Written by %s', 'typer' ), $author_link );
		             ?>
	            </span>
	        </span>
		<?php endif; ?>

		<span class="posted-on">
			<?php if ( $show_date ) : ?>
				<?php esc_html_e( 'Posted on ', 'typer' ) ?>
				<?php echo typer()->get_the_date() ?>
			<?php endif; ?>
			<?php if ( $show_reading ) : ?>
				<span class="entry-meta__text">
					<span class="no-reading-time"><?php esc_html_e( 'Less than', 'typer' ) ?></span>
					<span class="reading-time">0</span>
					<?php esc_html_e( 'min read', 'typer' ) ?>
				</span>
			<?php endif; ?>
        </span>
	</div>

	<?php do_action( 'typer_post_list_after_meta' ); ?>
</div>
