<?php
/**
 * The template for displaying archive page content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

?>

<div class="svq-article--list">
	<?php

	if ( have_posts() ) {

		$k = 1;
		while ( have_posts() ) {
			the_post();

			$media_size = get_post_format() === 'gallery' ? 'auto' : 'typer-img-md';

			typer()->set_post_data( 'listing_type', 'list' );
			typer()->set_post_data( 'media_width', 'normal' );
			typer()->set_post_data( 'media_size', $media_size );
			typer()->set_post_data( 'media_position', typer()->get_option( 'blog_post_listing_thumb_position' ) );

			do_action( 'typer_list_before_box', $k );

			typer()->get_template_part( 'template-parts/archive/article-box' );
			$k ++;
		}

		$nav = true;

		if ( isset( $show_navigation ) && is_bool( $show_navigation ) ) {
			$nav = $show_navigation;
		}

		if ( $nav ) {
			echo typer()->get_the_posts_navigation();
		}
	} else {
		typer()->get_template_part( 'template-parts/content/error/index' );
	}

	?>
</div>
