<?php
/**
 * The template for displaying archive page content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

$site_layout  = typer()->get_option( 'site_layout_archive' );
$layout_width = typer()->get_option( 'container_width_archive' );
$media_width  = typer()->get_option( 'blog_post_thumbnail_list_big' );

if ( $layout_width === 'large' && $site_layout === 'no-side' ) {
	$media_size = 'typer-img-wide-xxl';
} else {
	$media_size = $media_width === 'wide' ? 'typer-img-wide-xxl' : 'typer-img-wide-xl';
}

$components = [
	'categories',
	'title',
	'meta',
	'media',
	'excerpt'
];

?>
<div class="svq-article--big">
	<?php

	if ( have_posts() ) {

		$k = 1;
		while ( have_posts() ) {
			the_post();

			if ( get_post_format() === 'gallery' ) {
				$media_size = 'auto';
			}

			typer()->set_post_data( 'listing_type', 'list-big' );
			typer()->set_post_data( 'media_width', $media_width );
			typer()->set_post_data( 'media_size', $media_size );
			typer()->set_post_data( 'media_aspect_ratio', '16-9' );

			do_action( 'typer_list_before_box', $k );

			typer()->get_template_part( 'template-parts/archive/article-box', null, compact( 'components' ) );
			$k ++;
		}

		$nav = true;

		if ( isset( $show_navigation ) && is_bool( $show_navigation ) ) {
			$nav = $show_navigation;
		}

		if ( $nav ) {
			echo typer()->get_the_posts_navigation();
		}
	} else {
		typer()->get_template_part( 'template-parts/content/error/index' );
	}

	?>
</div>
