<?php
/**
 * The template for displaying archive page content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

$grid_classes = [];
$site_layout  = typer()->get_option( 'site_layout_archive' );
$layout_width = typer()->get_option( 'container_width_archive' );

if ( $site_layout !== 'no-side' || $layout_width === 'small' ) {
	foreach ( typer()->get_option( 'blog_grid_small_items' ) as $viewport => $value ) {
		$grid_classes = typer_build_grid_classes( $grid_classes, $viewport, $value );
	}
} else {
	foreach ( typer()->get_option( 'blog_grid_wide_items' ) as $viewport => $value ) {
		$grid_classes = typer_build_grid_classes( $grid_classes, $viewport, $value );
	}
}

$grid_classes = implode( ' ', $grid_classes );

?>

<?php if ( have_posts() ) : ?>
	<div class="svq-media-grid">
		<div class="svq-grid-articles svq-article--list-card <?php echo esc_attr( $grid_classes ) ?>">
			<?php

			$media_width = 'wide';
			$media_size  = 'typer-img-lg';

			$k = 1;
			while ( have_posts() ) {
				the_post();

				if ( $media_width === 'wide' && get_post_format() === 'gallery' ) {
					$media_size = 'auto';
				}

				if ( get_post_format() === 'video' ) {
					$media_aspect_ratio = '16-9';
				} else {
					$media_aspect_ratio = '1-1';
				}

				typer()->set_post_data( 'listing_type', 'grid' );
				typer()->set_post_data( 'grid_span', 'svq-grid-span-2' );
				typer()->set_post_data( 'media_size', $media_size );
				typer()->set_post_data( 'media_width', $media_width );
				typer()->set_post_data( 'media_aspect_ratio', $media_aspect_ratio );

				do_action( 'typer_masonry_grid_before_box', $k );

				typer()->get_template_part( 'template-parts/archive/article-box' );
				$k ++;
			}

			?>
		</div>

		<?php

		$nav = true;

		if ( isset( $show_navigation ) && is_bool( $show_navigation ) ) {
			$nav = $show_navigation;
		}

		if ( $nav ) {
			echo typer()->get_the_posts_navigation();
		}

		?>

	</div>
<?php else: ?>
	<?php typer()->get_template_part( 'template-parts/content/error/index' ) ?>
<?php endif; ?>
