<?php
/**
 * The template for displaying user interest content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

// Include posts loop
$show_navigation = false;
$title           = __( 'New from your network', 'typer' );

?>

<h3 class="title-section" data-first-letter="<?php echo substr( esc_attr( $title ), 0, 1 ) ?>">
	<?php echo esc_html( $title ) ?>
</h3>

<?php

if ( have_posts() ) {
	typer()->get_template_part(
		'template-parts/archive/listing-style/' . typer()->get_option( 'blog_post_listing' ),
		null,
		compact( 'show_navigation' ) );
} else {
	typer()->get_template_part( 'template-parts/content/error/feed' );
}

$title = __( 'Latest articles', 'typer' );

?>

<h3 class="title-section" data-first-letter="<?php echo substr( esc_attr( $title ), 0, 1 ) ?>">
	<?php echo esc_html( $title ) ?>
</h3>
