<?php

use function Seventhqueen\Typer\typer;

?>

<div class="entry-meta">
	<?php if ( in_array( 'avatar', typer()->get_option( 'blog_post_meta_items' ), true ) ) : ?>
		<div class="author-avatar">
			<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ) ?>" rel="author">
				<?php echo get_avatar( $post->post_author, '60', '', '', [ 'class' => 'avatar-img' ] ) ?>
			</a>
		</div>
	<?php endif; ?>

	<div class="entry-meta__content">
		<?php if ( in_array( 'author', typer()->get_option( 'blog_post_meta_items' ), true ) ) : ?>
			<span class="by-line">
	            <span class="author">
		            <?php printf( esc_html__( 'Written by %s', 'typer' ), get_the_author_posts_link() ) ?>
	            </span>
	        </span>
		<?php endif; ?>
		<?php if ( in_array( 'date', typer()->get_option( 'blog_post_meta_items' ), true ) ) : ?>
			<span class="posted-on">
				<?php echo typer()->get_the_date() ?>
			</span>
		<?php endif; ?>
	</div>

	<?php do_action( 'typer_post_list_after_meta' ); ?>
</div>
