<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

?>

<?php if ( typer()->is_primary_sidebar_active() ) : ?>

	<?php

	if ( is_single() ) {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_primary_post' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_post' );

		if ( ! $is_sticky ) {
			$is_sticky = (bool) get_post_meta( get_the_ID(), '_sidebar_primary_sticky', true );
		}
	} elseif ( is_archive() || is_search() || is_home() ) {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_primary_archive' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_archive' );
	} else {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_primary_general' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_general' );
	}

	$sticky_class = $is_sticky ? 'svq-sticky-el' : '';
	$gap          = $sticky_gap['size'];

	if ( $is_sticky ) {
		\Typer_Assets::instance()->enqueue_hc_sticky();
	}

	?>

	<div class="svq-sidebar-page primary-sidebar" id="primary-sidebar">
		<div class="svq-sidebar-content widget-area <?php echo esc_attr( $sticky_class ) ?>"
			 data-stick-to="primary-sidebar" data-top="<?php echo esc_attr( $gap ) ?>">
			<?php typer()->display_primary_sidebar(); ?>
		</div>
	</div><!-- #primary -->

<?php endif; ?>

<?php if ( typer()->is_secondary_sidebar_active() ) : ?>

	<?php
	if ( is_single() ) {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_secondary_post' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_post' );

		if ( ! $is_sticky ) {
			$is_sticky = (bool) get_post_meta( get_the_ID(), '_sidebar_secondary_sticky', true );
		}
	} elseif ( is_archive() || is_search() || is_home() ) {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_secondary_archive' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_archive' );
	} else {
		$is_sticky  = typer()->get_option( 'sticky_sidebar_secondary_general' );
		$sticky_gap = typer()->get_option( 'sticky_sidebar_gap_general' );
	}

	$sticky_class = $is_sticky ? 'svq-sticky-el' : '';
	$gap          = $sticky_gap['size'];

	if ( $is_sticky ) {
		\Typer_Assets::instance()->enqueue_hc_sticky();
	}
	?>

	<div class="svq-sidebar-page secondary-sidebar" id="secondary-sidebar">
		<div class="svq-sidebar-content widget-area <?php echo esc_attr( $sticky_class ) ?>"
			 data-stick-to="secondary-sidebar" data-top="<?php echo esc_attr( $gap ) ?>">
			<?php typer()->display_secondary_sidebar(); ?>
		</div>
	</div><!-- #secondary -->

<?php endif;
