<?php
/**
 * Seventhqueen\Typer\Upgrades\Component class
 *
 * @package typer
 */

namespace Seventhqueen\Typer\Upgrades;

use Seventhqueen\Typer\Component_Interface;
use function Seventhqueen\Typer\typer;

/**
 * Class Component
 * @package Seventhqueen\Typer\Upgrades
 */
class Component implements Component_Interface {

	private $option_name = 'typer-upgrades';

	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */
	public function get_slug() {
		return 'upgrades';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */
	public function initialize() {
		add_action( 'init', [ $this, 'do_upgrades' ] );

		if ( function_exists( 'pmpro_license_nag' ) ) {
			remove_action( 'admin_notices', 'pmpro_license_nag' );
		}

	}

	public function do_upgrades() {
		$old_upgrades = get_option( $this->option_name, [] );

		$upgrades = [
			'1.0.0' => '_upgrade_100',
			'1.1.0' => '_upgrade_110',
		];

		$currentVersion = typer()->get_version();

		foreach ( $upgrades as $version => $function ) {
			if ( ! isset( $old_upgrades[ $version ] ) && version_compare( $currentVersion, $version, '>=' ) ) {

				// Run the upgrade
				$this->$function();
				$old_upgrades[ $version ] = true;
			}
		}
		update_option( $this->option_name, $old_upgrades );
	}

	private function _upgrade_100() {

		// rtMedia
		update_option( 'rtmedia_inspirebook_release_notice', 'hide' );
		update_option( 'rtmedia_premium_addon_notice', 'hide' );
		update_option( 'rtmedia-update-template-notice-v3_9_4', 'hide' );
		update_site_option( 'install_transcoder_admin_notice', '0' );

		// Elementor theme settings
		update_option( 'elementor_disable_typography_schemes', 'yes' );
		update_option( 'elementor_page_title_selector', 'h1.entry-title' );
		update_option( 'elementor_viewport_lg', '992' );
		update_option( 'elementor_container_width', '1140' );

		// Elementor color scheme
		update_option( 'elementor_scheme_color', [
				1 => typer()->get_option( 'text-color' ), //texts
				2 => typer()->get_option( 'tertiary-color' ), //secondary
				3 => typer()->get_option( 'text-color' ), //texts
				4 => typer()->get_option( 'primary-color' ) //primary
			]
		);

		if ( defined( 'ELEMENTOR_PATH' ) ) {
			\Elementor\Plugin::$instance->files_manager->clear_cache();
		}
	}

	private function _upgrade_110() {

		// Elementor theme settings
		update_option( 'elementor_disable_color_schemes', 'yes' );

		if ( defined( 'ELEMENTOR_PATH' ) ) {
			\Elementor\Plugin::$instance->files_manager->clear_cache();
		}
	}

}
