<?php if ( $params['typer_settings']['pagination'] && ( ! $params['typer_settings']['pagination_next_prev'] || ! $params['typer_settings']['pagination_page_numbers'] ) ): ?>

	<?php

	$pagination_class = 'pagination justify-content-center';
	if ( $params['typer_settings']['pagination_ajax'] ) {
		$pagination_class .= ' svq-ajax-pagination';
	}

	?>

	<div class="<?php echo esc_attr( $pagination_class ); ?>"
	     data-ajax="<?php echo admin_url( 'admin-ajax.php' ); ?>"
	     data-nonce="<?php echo wp_create_nonce( 'typer-widget-get-posts' ); ?>"
	     data-current-page="<?php echo esc_attr( $params['typer_settings']['current_page'] ); ?>"
	     data-params="<?php echo htmlspecialchars( json_encode( $params ), ENT_QUOTES, 'UTF-8' ); ?>">
		<?php

		echo paginate_links( [
			'total'        => $query->max_num_pages,
			'format'       => '?typer_page=%#%',
			'current'      => $params['typer_settings']['current_page'],
			'show_all'     => false,
			'type'         => 'plain',
			'end_size'     => 2,
			'mid_size'     => 1,
			'prev_next'    => ! (bool) $params['typer_settings']['pagination_next_prev'],
			'prev_text'    => sprintf( '<i></i> %1$s', __( 'Newer Posts', 'typer' ) ),
			'next_text'    => sprintf( '%1$s <i></i>', __( 'Older Posts', 'typer' ) ),
			'add_args'     => false,
			'add_fragment' => '',
		] );

		?>
	</div>

<?php endif; ?>
