<?php

use function Seventhqueen\Typer\typer;

if ( $params['typer_settings']['image_wide'] ) {
	$params['typer_settings']['media_size'] = 'typer-img-lg';
} else {
	$params['typer_settings']['media_size'] = 'typer-img-sm';
}

$masonry_classes   = [];
$masonry_classes[] = 'svq-masonry-sm-' . 12 / (int) $params['typer_settings']['col-mobile'];
$masonry_classes[] = 'svq-masonry-md-' . 12 / (int) $params['typer_settings']['col-tablet'];
$masonry_classes[] = 'svq-masonry-lg-' . 12 / (int) $params['typer_settings']['col-desktop'];
$masonry_classes   = implode( ' ', $masonry_classes );
?>

<div class="svq-media-masonry">
	<div class="svq-masonry-articles svq-article--list-card <?php echo esc_attr( $masonry_classes ) ?>">
		<div class="svq-grid-sizer"></div>
		<?php
		typer()->get_template_part( 'inc/Elementor/Widgets/templates/posts/parts/loop', '', [
			'query'  => $query,
			'params' => $params
		] );
		?>
	</div>
</div>

<?php
typer()->get_template_part( 'inc/Elementor/Widgets/templates/posts/parts/pagination', '', [
	'query'  => $query,
	'params' => $params
] );
?>
