<div class="svq-gallery-grid <?php echo esc_attr( $classes ) ?>">
	<?php foreach ( $items as $key => $item ) : ?>
		<div class="svq-gallery__item">
			<div class="svq-gallery__image-wrapp" data-more="<?php echo esc_attr( $count ) ?>">
				<a href="<?php echo esc_url( wp_get_attachment_image_url( $item['image']['id'], 'large' ) ) ?>"
				   class="svq-gallery__image-link"
				   data-fancybox="gallery"
				   data-caption="<?php echo esc_attr( $item['caption'] ) ?>">
					<?php

					echo wp_get_attachment_image(
						$item['image']['id'],
						'medium',
						false,
						[
							'class'           => 'svq-gallery__image',
							'data-object-fit' => 'cover'
						]
					)

					?>
					<noscript>
						<?php

						echo wp_get_attachment_image(
							$item['image']['id'],
							'medium',
							false,
							[ 'class' => 'skip-lazy' ]
						)

						?>
					</noscript>
				</a>
			</div>
		</div>
	<?php endforeach; ?>
</div>
